/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.command.ConnectionInfo;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.util.Iterator;

public class RemoveConnectionCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final InteractionGraph graph;
    private Connection connection;
    private Trigger sourceLink = null;
    private Content sourceContent = null;
    private final boolean convertLinksToContent;
    private ConnectionInfo origConnectionInfo;

    public RemoveConnectionCommand(Connection connection, boolean convertLinksToContent) {
        this.graph = connection.getInteractionGraph();
        this.convertLinksToContent = convertLinksToContent;
        this.connection = connection;
    }

    public String getPresentationName() {
        return "Remove connection " + this.connection;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.origConnectionInfo = new ConnectionInfo(this.connection);
        if (this.connection instanceof NavConnection) {
            NavConnection navConnection = (NavConnection)this.connection;
            this.sourceLink = null;
            Iterator i = this.connection.getDeviceTypesVisibleTo().iterator();
            while (i.hasNext()) {
                Trigger trigger;
                DeviceType deviceType = (DeviceType)i.next();
                Control source = navConnection.getSource(deviceType);
                if (!(source instanceof Trigger) || (trigger = (Trigger)source).getStyle(deviceType) != Trigger.HYPERLINK) continue;
                this.sourceLink = trigger;
            }
        }
        this.graph.remove(this.connection);
        this.connection.dispose();
        if (this.connection instanceof NavConnection && this.sourceLink != null && this.convertLinksToContent) {
            this.sourceContent = (Content)this.sourceLink.getContent().clone();
            Iterator i = this.sourceLink.getDeviceTypesVisibleTo().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                this.sourceContent.setTransform(aDeviceType, this.sourceLink.getTransform(aDeviceType));
            }
            this.sourceLink.getDialog().addControlAfter(this.sourceLink, this.sourceContent);
            this.sourceLink.getDialog().removeControl(this.sourceLink);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        if (this.sourceContent != null) {
            this.sourceContent.getDialog().addControlAfter(this.sourceContent, this.sourceLink);
            this.sourceContent.getDialog().removeControl(this.sourceContent);
        }
        this.connection = this.origConnectionInfo.createConnection();
        this.graph.add(this.connection);
    }

    public Connection getConnection() {
        return this.connection;
    }
}

