/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.OrgConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MergePagesCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Page page1;
    private Page page2 = null;
    private Rectangle2D page1OldBounds;
    private Rectangle2D page2OldBounds;
    private AffineTransform page2OldTransform;
    private Rectangle2D page1CenterOldBounds;
    private Rectangle2D page2CenterOldBounds;
    private Map page2InConnections = new HashMap();
    private Map page2OutConnections = new HashMap();
    private List page2CenterControls;

    public MergePagesCommand(Page page1) {
        this.page1 = page1;
    }

    public MergePagesCommand(Page page1, Page page2) {
        this.page1 = page1;
        this.page2 = page2;
    }

    public String getPresentationName() {
        return "Merge pages " + this.page1 + " and " + this.page2;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        if (this.page2 == null) {
            Dialog d = this.page1.getDialog();
            List pages = d.getPages(this.page1.getDeviceType());
            int page2Index = pages.indexOf(this.page1) + 1;
            this.page2 = page2Index >= pages.size() ? null : (Page)pages.get(page2Index);
        }
        if (this.page2 != null) {
            Connection connection;
            this.page1OldBounds = this.page1.getBounds();
            this.page1CenterOldBounds = this.page1.getRegion(Direction.CENTER).getBounds();
            this.page2OldBounds = this.page2.getBounds();
            this.page2CenterOldBounds = this.page2.getRegion(Direction.CENTER).getBounds();
            this.page2OldTransform = this.page2.getTransform();
            Iterator i = this.page2.getInConnections().iterator();
            while (i.hasNext()) {
                connection = (Connection)i.next();
                this.page2InConnections.put(connection, connection.getShape(this.page2.getDeviceType()));
            }
            i = this.page2.getOutConnections().iterator();
            while (i.hasNext()) {
                connection = (OrgConnection)i.next();
                this.page2OutConnections.put(connection, connection.getShape(this.page2.getDeviceType()));
            }
            this.page2CenterControls = new ArrayList(this.page2.getRegion(Direction.CENTER).getControls());
            this.page1.merge(this.page2);
            if (this.page1.getDeviceType() != DeviceType.VOICE) {
                this.page1.setBounds(new Rectangle2D.Double(this.page1OldBounds.getX(), this.page1OldBounds.getY(), Math.max(this.page1OldBounds.getWidth(), this.page2OldBounds.getWidth()), this.page1OldBounds.getHeight() + this.page2CenterOldBounds.getHeight()));
                double page1CenterOldHeight = this.page1CenterOldBounds.getHeight();
                DeviceType page2DeviceType = this.page2.getDeviceType();
                Iterator i2 = this.page2CenterControls.iterator();
                while (i2.hasNext()) {
                    Control control = (Control)i2.next();
                    AffineTransform transform = control.getTransform(page2DeviceType);
                    transform.translate(0.0, page1CenterOldHeight);
                    control.setTransform(page2DeviceType, transform);
                }
            }
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        if (this.page2 != null) {
            GeneralPath shape;
            Connection connection;
            this.page2 = this.page1.split(this.page2CenterControls);
            Iterator i = this.page2InConnections.keySet().iterator();
            while (i.hasNext()) {
                connection = (Connection)i.next();
                shape = (GeneralPath)this.page2InConnections.get(connection);
                connection.adjustDestPage(this.page2.getDeviceType(), this.page2);
                connection.setShape(this.page2.getDeviceType(), shape);
            }
            i = this.page2OutConnections.keySet().iterator();
            while (i.hasNext()) {
                connection = (OrgConnection)i.next();
                shape = (GeneralPath)this.page2OutConnections.get(connection);
                ((OrgConnection)connection).setSource(this.page2.getDeviceType(), this.page2);
                connection.setShape(this.page2.getDeviceType(), shape);
            }
            this.page1.setBounds(this.page1OldBounds);
            this.page2.setBounds(this.page2OldBounds);
            this.page2.setTransform(this.page2OldTransform);
            double page1CenterOldHeight = this.page1CenterOldBounds.getHeight();
            DeviceType page2DeviceType = this.page2.getDeviceType();
            Iterator i2 = this.page2CenterControls.iterator();
            while (i2.hasNext()) {
                Control control = (Control)i2.next();
                AffineTransform transform = control.getTransform(page2DeviceType);
                transform.translate(0.0, -page1CenterOldHeight);
                control.setTransform(page2DeviceType, transform);
            }
        }
    }
}

