/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GroupStrokesCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Collection contents;
    private final Map contentsRegions = new HashMap();
    private final DeviceType deviceType;
    private Content newContent;

    public GroupStrokesCommand(Collection contents, DeviceType deviceType) {
        this.contents = contents;
        this.deviceType = deviceType;
    }

    public String getPresentationName() {
        return "Combined strokes in " + this.contents + " relative to " + this.deviceType;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        Content content;
        if (this.contents.size() <= 1) {
            return;
        }
        Iterator i = this.contents.iterator();
        Content firstContent = (Content)i.next();
        this.newContent = (Content)firstContent.clone();
        while (i.hasNext()) {
            content = (Content)i.next();
            Iterator j = content.getStrokes().iterator();
            while (j.hasNext()) {
                GeneralPath path = (GeneralPath)j.next();
                GeneralPath newPath = (GeneralPath)path.clone();
                newPath.transform(content.getTransform(this.deviceType));
                try {
                    newPath.transform(this.newContent.getTransform(this.deviceType).createInverse());
                }
                catch (NoninvertibleTransformException e) {
                    DamaskAppExceptionHandler.log(e);
                }
                this.newContent.addStroke(newPath);
            }
        }
        i = this.contents.iterator();
        while (i.hasNext()) {
            content = (Content)i.next();
            HashMap<PageRegion, Integer> regionPositions = new HashMap<PageRegion, Integer>();
            Iterator j = content.getDeviceTypesVisibleTo().iterator();
            while (j.hasNext()) {
                DeviceType aDeviceType = (DeviceType)j.next();
                PageRegion aRegion = content.getPageRegion(aDeviceType);
                regionPositions.put(aRegion, new Integer(aRegion.getControls().indexOf(content)));
            }
            this.contentsRegions.put(content, regionPositions);
        }
        firstContent.getDialog().addControl((Map)this.contentsRegions.get(firstContent), this.newContent);
        i = this.contents.iterator();
        while (i.hasNext()) {
            content = (Content)i.next();
            content.getDialog().removeControl(content);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        Dialog dialog = this.newContent.getDialog();
        dialog.removeControl(this.newContent);
        Iterator i = this.contents.iterator();
        while (i.hasNext()) {
            Content content = (Content)i.next();
            dialog.addControl((Map)this.contentsRegions.get(content), content);
        }
    }
}

