/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.image.BufferedImage;
import java.util.Collection;

public class EditContentCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final boolean changeText;
    private final String oldText;
    private final String newText;
    private final boolean changeImage;
    private final BufferedImage oldImage;
    private final BufferedImage newImage;
    private final boolean changeStrokes;
    private final Collection oldStrokes;
    private final Collection newStrokes;
    private final Content content;

    public EditContentCommand(Content content, String newText) {
        this(content, true, newText, false, null, false, null);
    }

    public EditContentCommand(Content content, BufferedImage newImage) {
        this(content, false, null, true, newImage, false, null);
    }

    protected EditContentCommand(Content content, boolean changeText, String newText, boolean changeImage, BufferedImage newImage, boolean changeStrokes, Collection newStrokes) {
        this.content = content;
        this.oldText = content.getText();
        this.changeText = changeText;
        this.newText = newText;
        this.oldImage = content.getImage();
        this.changeImage = changeImage;
        this.newImage = newImage;
        this.oldStrokes = content.getStrokes();
        this.changeStrokes = changeStrokes;
        this.newStrokes = newStrokes;
    }

    public String getPresentationName() {
        StringBuffer sb = new StringBuffer();
        sb.append("Edit content " + this.content + " ");
        if (this.changeText) {
            sb.append("text");
        } else if (this.changeImage) {
            sb.append("image");
        } else if (this.changeStrokes) {
            sb.append("strokes");
        }
        return sb.toString();
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        if (this.changeText) {
            this.content.setText(this.newText);
        }
        if (this.changeImage) {
            this.content.setImage(this.newImage);
        }
        if (this.changeStrokes) {
            this.content.setStrokes(this.newStrokes);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        if (this.changeText) {
            this.content.setText(this.oldText);
        }
        if (this.changeImage) {
            this.content.setImage(this.oldImage);
        }
        if (this.changeStrokes) {
            this.content.setStrokes(this.oldStrokes);
        }
    }
}

