/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.ConnectionSource;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.connection.OrgConnection;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.userevent.DamaskUserEvent;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ConnectionInfo {
    private final DeviceType deviceType;
    private final boolean forAllDevices;
    private final ConnectionSource source;
    private final ConnectionDest dest;
    private final Map shapes = new HashMap();
    private final DamaskUserEvent userEvent;
    private final int condition;

    public ConnectionInfo(Connection connection) {
        this.deviceType = connection.getOrigSpecifiedDeviceType();
        this.forAllDevices = connection.isForAllDeviceTypes();
        this.source = connection.getConnectionSource(this.deviceType);
        this.dest = connection.getConnectionDest(this.deviceType);
        Iterator i = connection.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            this.shapes.put(deviceType, connection.getShape(deviceType));
        }
        if (connection instanceof NavConnection) {
            NavConnection navConnection = (NavConnection)connection;
            this.userEvent = navConnection.getUserEvent();
            this.condition = navConnection.getCondition();
        } else {
            this.userEvent = null;
            this.condition = -1;
        }
    }

    public static Set createSet(Collection connections) {
        HashSet<ConnectionInfo> connectionInfos = new HashSet<ConnectionInfo>();
        Iterator i = connections.iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            connectionInfos.add(new ConnectionInfo(connection));
        }
        return connectionInfos;
    }

    public DeviceType getSpecifiedDeviceType() {
        return this.deviceType;
    }

    public boolean isForAllDevices() {
        return this.forAllDevices;
    }

    public GeneralPath getShape(DeviceType deviceType) {
        return (GeneralPath)this.shapes.get(deviceType);
    }

    public ConnectionSource getSourceForSpecifiedDeviceType() {
        return this.source;
    }

    public DamaskUserEvent getUserEvent() {
        return this.userEvent;
    }

    public int getCondition() {
        return this.condition;
    }

    public ConnectionDest getDestForSpecifiedDeviceType() {
        return this.dest;
    }

    public boolean isNav() {
        return this.userEvent != null && this.condition != -1;
    }

    public Connection createConnection() {
        Connection newConnection = this.condition == -1 ? new OrgConnection(this.deviceType, this.forAllDevices, (Page)this.source, (Page)this.dest, (GeneralPath)this.shapes.get(this.deviceType)) : new NavConnection(this.deviceType, this.forAllDevices, (Control)this.source, this.userEvent, this.condition, this.dest, (GeneralPath)this.shapes.get(this.deviceType));
        if (this.forAllDevices) {
            Iterator i = Damask.getSupportedDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                newConnection.setShape(aDeviceType, (GeneralPath)this.shapes.get(this.deviceType));
            }
        }
        return newConnection;
    }

    public Connection findConnection(InteractionGraph graph) {
        Connection result = null;
        Collection connections = graph.getConnections();
        Iterator i = connections.iterator();
        while (i.hasNext()) {
            boolean match;
            Connection connection = (Connection)i.next();
            boolean bl = match = connection.getOrigSpecifiedDeviceType() == this.deviceType && connection.isForAllDeviceTypes() == this.forAllDevices && connection.getConnectionSource(this.deviceType) == this.source && connection.getConnectionDest(this.deviceType) == this.dest;
            match = connection instanceof OrgConnection ? (match &= this.userEvent == null && this.condition == -1) : (match &= ((NavConnection)connection).getUserEvent().matches(this.userEvent) && ((NavConnection)connection).getCondition() == this.condition);
            if (!match) continue;
            result = connection;
            break;
        }
        return result;
    }
}

