/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.Rectangle2D;

public class ChangePageRegionCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final Component component;
    private DeviceType deviceType;
    private PageRegion oldRegion;
    private final PageRegion newRegion;
    private final Rectangle2D groupBounds;

    public ChangePageRegionCommand(Component component, PageRegion oldRegion, PageRegion newRegion) {
        this.component = component;
        this.oldRegion = oldRegion;
        this.deviceType = null;
        this.newRegion = newRegion;
        this.groupBounds = component instanceof ComponentGroup ? ((ComponentGroup)component).getBoundsInPageRegion(oldRegion) : null;
    }

    public ChangePageRegionCommand(Control control, DeviceType deviceType, PageRegion newRegion) {
        this.component = control;
        this.deviceType = deviceType;
        this.oldRegion = null;
        this.newRegion = newRegion;
        this.groupBounds = null;
    }

    public String getPresentationName() {
        return "Changing page region of " + this.component + ": " + this.oldRegion + "->" + this.newRegion;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        if (this.oldRegion == null) {
            this.oldRegion = ((Control)this.component).getPageRegion(this.deviceType);
        }
        if (this.oldRegion == this.newRegion) {
            return;
        }
        if (this.component instanceof ComponentGroup) {
            ((ComponentGroup)this.component).setBoundsInPageRegion(this.oldRegion, null);
            ((ComponentGroup)this.component).setBoundsInPageRegion(this.newRegion, this.groupBounds);
        } else {
            this.oldRegion.getPage().getDialog().changeControlPageRegion((Control)this.component, this.newRegion);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        if (this.oldRegion == this.newRegion) {
            return;
        }
        if (this.component instanceof ComponentGroup) {
            ((ComponentGroup)this.component).setBoundsInPageRegion(this.newRegion, null);
            ((ComponentGroup)this.component).setBoundsInPageRegion(this.oldRegion, this.groupBounds);
        } else {
            this.oldRegion.getPage().getDialog().changeControlPageRegion((Control)this.component, this.oldRegion);
        }
    }
}

