/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;

public class AddTemplateCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final InteractionGraph graph;
    private final TemplateDialog template;

    public AddTemplateCommand(InteractionGraph graph, TemplateDialog template) {
        this.graph = graph;
        this.template = template;
    }

    public String getPresentationName() {
        return "Add template " + this.template.toLongString();
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.graph.addTemplate(this.template);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.graph.removeTemplate(this.template);
    }
}

