/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.InteractionSubgraph;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.pattern.Pattern;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AddPatternInstanceCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final InteractionGraph graph;
    private final Pattern pattern;
    private final Page mergePatternPage;
    private final Point2D mergePt;
    private final Page mergeGraphPage;
    private InteractionSubgraph instanceSubgraph;
    private final Set newComponents = new HashSet();

    public AddPatternInstanceCommand(InteractionGraph graph, Pattern pattern, Page mergePatternPage, Point2D mergePt) {
        this.graph = graph;
        this.pattern = pattern;
        this.mergePatternPage = mergePatternPage;
        this.mergePt = mergePt;
        this.mergeGraphPage = null;
    }

    public AddPatternInstanceCommand(InteractionGraph graph, Pattern pattern, Page mergePatternPage, Page mergeGraphPage) {
        this.graph = graph;
        this.pattern = pattern;
        this.mergePatternPage = mergePatternPage;
        this.mergePt = null;
        this.mergeGraphPage = mergeGraphPage;
    }

    public String getPresentationName() {
        return "Add instance of pattern " + this.pattern + " to " + this.graph + ", merging " + this.mergePatternPage + " with " + this.mergeGraphPage + " at " + this.mergePt;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.instanceSubgraph = this.graph.mergePatternInstance(this.pattern, this.mergePatternPage, this.mergePt, this.mergeGraphPage, this.newComponents);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        Iterator i = this.instanceSubgraph.getPatternInstances().iterator();
        while (i.hasNext()) {
            PatternInstance instance = (PatternInstance)i.next();
            this.graph.remove(instance);
            instance.dispose();
        }
        i = this.instanceSubgraph.getConnections().iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            this.graph.remove(connection);
            connection.dispose();
        }
        i = this.newComponents.iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            Dialog dialog = component.getDialog();
            if (dialog != null) {
                if (component instanceof ComponentGroup) {
                    dialog.removeGroup((ComponentGroup)component);
                } else {
                    dialog.removeControl((Control)component);
                }
            }
            component.dispose();
        }
        i = this.instanceSubgraph.getDialogs().iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            this.graph.remove(dialog);
            dialog.dispose();
        }
    }
}

