/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;

public class AddItemCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private static final int DEFAULT_INDEX = -1;
    private final Select control;
    private final int index;
    private final Select.Item item;

    public AddItemCommand(Select control, int index, Select.Item item) {
        this.control = control;
        this.index = index;
        this.item = item;
    }

    public AddItemCommand(Select control, Select.Item item) {
        this(control, -1, item);
    }

    public String getPresentationName() {
        return "Add " + this.item.toLongString() + " to " + this.control;
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        if (this.index == -1) {
            this.control.addItem(this.item);
        } else {
            this.control.addItem(this.index, this.item);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.control.removeItem(this.item);
    }
}

