/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class AddDialogCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final InteractionGraph graph;
    private final Dialog dialog;

    public AddDialogCommand(InteractionGraph graph, Dialog dialog) {
        this.graph = graph;
        this.dialog = dialog;
    }

    public AddDialogCommand(InteractionGraph graph, Content title, DeviceType deviceType, boolean addToAllDevices, Rectangle2D dialogPageBounds, AffineTransform dialogPageTransform) {
        deviceType.verifyTypeIsNotAll();
        this.graph = graph;
        this.dialog = new Dialog(addToAllDevices ? DeviceType.ALL : deviceType, title);
        this.setInitialBoundsAndTransform(this.dialog, deviceType, dialogPageBounds, dialogPageTransform);
        double x = dialogPageBounds.getX();
        double y = dialogPageBounds.getY();
        Iterator i = this.dialog.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            if (aDeviceType == deviceType) continue;
            this.setInitialBoundsAndTransform(this.dialog, aDeviceType, new Rectangle2D.Double(x, y, aDeviceType.getDefaultWidth(), aDeviceType.getDefaultHeight()), dialogPageTransform);
        }
    }

    private void setInitialBoundsAndTransform(Dialog dialog, DeviceType deviceType, Rectangle2D bounds, AffineTransform transform) {
        Page firstPage = dialog.getFirstPage(deviceType);
        if (deviceType == DeviceType.VOICE) {
            dialog.setTransform(deviceType, transform);
            dialog.setBounds(deviceType, bounds);
            firstPage.setTransform(new AffineTransform());
            firstPage.setBounds(bounds);
        } else {
            firstPage.setTransform(transform);
            firstPage.setBounds(bounds);
        }
    }

    public String getPresentationName() {
        return "Create dialog " + this.dialog.toLongString();
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        this.graph.add(this.dialog);
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        this.graph.remove(this.dialog);
    }
}

