/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;

public class AddControlCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private Dialog dialog;
    private final PageRegion region;
    private final Control control;
    private final Control controlBefore;
    private Page voicePageWithTrigger = null;
    private Page splitVoicePage = null;
    private final String controlString;

    public AddControlCommand(PageRegion region, Control control) {
        this.region = region;
        this.controlBefore = null;
        this.control = control;
        this.controlString = control.toLongString();
    }

    public AddControlCommand(Control controlBefore, Control control) {
        this.region = null;
        this.controlBefore = controlBefore;
        this.control = control;
        this.controlString = control.toLongString();
    }

    public String getPresentationName() {
        if (this.region != null) {
            return "Add control " + this.controlString + " to page " + this.region;
        }
        return "Add control " + this.controlString + " before " + this.controlBefore + " in dialog " + this.controlBefore.getDialog();
    }

    public boolean canRedo() {
        return true;
    }

    public void run() {
        if (this.region != null) {
            this.dialog = this.region.getPage().getDialog();
            this.dialog.addControlAtBeginning(this.region, this.control);
        } else {
            this.dialog = this.controlBefore.getDialog();
            this.dialog.addControlAfter(this.controlBefore, this.control);
        }
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        if (this.splitVoicePage != null) {
            this.voicePageWithTrigger.merge(this.splitVoicePage);
        }
        this.dialog.removeControl(this.control);
    }
}

