/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.command;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.command.ConnectionInfo;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.ConnectionSource;
import edu.berkeley.guir.damask.connection.NavConnection;
import edu.berkeley.guir.damask.connection.OrgConnection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.userevent.DamaskUserEvent;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.lib.collection.Map2D;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AddConnectionCommand
extends UndoableCommand
implements ModifyGraphCommand {
    private final DeviceType deviceType;
    private final boolean addToAllDeviceTypes;
    private final DamaskUserEvent userEvent;
    private InteractionGraph graph;
    private final ConnectionSource source;
    private final int condition;
    private final ConnectionDest dest;
    private final GeneralPath generalPathForDeviceType;
    private Connection connection;
    private ConnectionInfo newConnectionInfo;
    private Page voicePageWithTrigger = null;
    private Page splitVoicePage = null;
    private final Set removedConnections = new HashSet();
    private final Map2D changedShapeConnections = new Map2D();
    private Trigger sourceTrigger = null;
    private Content voiceContentBeforeSourceTrigger = null;

    public AddConnectionCommand(DeviceType deviceType, boolean addToAllDeviceTypes, ConnectionSource source, DamaskUserEvent userEvent, int condition, ConnectionDest dest, GeneralPath generalPathForDeviceType) {
        this.deviceType = deviceType;
        this.addToAllDeviceTypes = addToAllDeviceTypes;
        this.userEvent = userEvent;
        this.source = source;
        this.condition = condition;
        this.dest = dest;
        this.generalPathForDeviceType = generalPathForDeviceType;
    }

    public String getPresentationName() {
        return "Add connection: " + this.source + "->" + this.dest + ", origDeviceType=" + this.deviceType + ", forAll=" + this.addToAllDeviceTypes + ", userEvent=" + this.userEvent + ", condition=" + this.condition + ", path=" + Arrays.asList(DamaskAppUtils.getEndPoints(this.generalPathForDeviceType));
    }

    public boolean canRedo() {
        return true;
    }

    private void removeConnectionAndSaveInfo(Connection connection) {
        this.removedConnections.add(new ConnectionInfo(connection));
        connection.getInteractionGraph().remove(connection);
        connection.dispose();
    }

    private void changeConnectionShape(Connection connection, DeviceType deviceType, GeneralPath path) {
        this.changedShapeConnections.put(connection, deviceType, connection.getShape(deviceType));
        connection.setShape(deviceType, path);
    }

    private void restoreConnectionShape(Connection connection, DeviceType deviceType) {
        GeneralPath origShape = (GeneralPath)this.changedShapeConnections.get(connection, deviceType);
        if (origShape != null) {
            connection.setShape(deviceType, origShape);
        }
    }

    private Set getConnectionsForShapeRestoration() {
        return this.changedShapeConnections.getRows();
    }

    private Set getDeviceTypesForShapeRestoration() {
        return this.changedShapeConnections.getCols();
    }

    private void setDefaultConnectionShapes(Connection connection) {
        Iterator i = connection.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            if (aDeviceType == this.deviceType || aDeviceType == DeviceType.VOICE) continue;
            ConnectionSource sourceForADeviceType = connection.getConnectionSource(aDeviceType);
            Rectangle2D boundsForSourceForADeviceType = sourceForADeviceType.localToGlobal(aDeviceType, sourceForADeviceType.getBounds(aDeviceType));
            ConnectionDest destForADeviceType = connection.getConnectionDest(aDeviceType);
            Rectangle2D boundsForDestForADeviceType = destForADeviceType.localToGlobal(aDeviceType, destForADeviceType.getBounds(aDeviceType));
            GeneralPath aGeneralPath = new GeneralPath();
            aGeneralPath.moveTo((float)boundsForSourceForADeviceType.getX(), (float)boundsForSourceForADeviceType.getY());
            aGeneralPath.lineTo((float)boundsForDestForADeviceType.getX(), (float)boundsForDestForADeviceType.getY());
            connection.setShape(aDeviceType, aGeneralPath);
        }
    }

    private void replaceContentWithTrigger(Content sourceControl) {
        Control prevControlWithPrompt;
        if (this.sourceTrigger == null) {
            this.sourceTrigger = new Trigger(sourceControl.getDeviceType(), (Content)sourceControl.clone());
        }
        this.sourceTrigger.setStyle(sourceControl.getDeviceType(), Trigger.HYPERLINK);
        Iterator i = sourceControl.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            if (aDeviceType == DeviceType.VOICE) continue;
            this.sourceTrigger.setBounds(aDeviceType, sourceControl.getBounds(aDeviceType));
            this.sourceTrigger.setTransform(aDeviceType, sourceControl.getTransform(aDeviceType));
            this.sourceTrigger.getContent().setTransform(aDeviceType, new AffineTransform());
        }
        Dialog dialog = sourceControl.getDialog();
        if (this.sourceTrigger.isVisibleToDeviceType(DeviceType.VOICE) && (prevControlWithPrompt = DamaskUtils.getPreviousControlWithPrompt(sourceControl.getPageRegion(DeviceType.VOICE), sourceControl)) == null) {
            this.voiceContentBeforeSourceTrigger = new Content(DeviceType.VOICE, "Text");
            dialog.addControlAfter(sourceControl, this.voiceContentBeforeSourceTrigger);
            this.voiceContentBeforeSourceTrigger.setTransform(DeviceType.VOICE, sourceControl.getTransform(DeviceType.VOICE));
        }
        if (this.voiceContentBeforeSourceTrigger != null) {
            dialog.addControlAfter(this.voiceContentBeforeSourceTrigger, this.sourceTrigger);
        } else {
            dialog.addControlAfter(sourceControl, this.sourceTrigger);
        }
        dialog.removeControl(sourceControl);
    }

    protected OrgConnection getOrgConnection(Page sourcePage, Page destPage, boolean isForAllDeviceTypes) {
        OrgConnection result = null;
        Iterator i = sourcePage.getOutConnections().iterator();
        while (i.hasNext()) {
            OrgConnection outConnection = (OrgConnection)i.next();
            if (outConnection.getDest(destPage.getDeviceType()) != destPage || isForAllDeviceTypes != outConnection.isForAllDeviceTypes()) continue;
            result = outConnection;
            break;
        }
        return result;
    }

    protected boolean navConnectionExists(Page sourcePage, Page destPage, boolean isForAllDeviceTypes) {
        DamaskUtils.checkValidArgument(sourcePage.getDeviceType() == destPage.getDeviceType(), "source and dest pages must be the same device type");
        DeviceType aDeviceType = sourcePage.getDeviceType();
        Iterator i = this.graph.getConnections(this.deviceType).iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            if (!(connection instanceof NavConnection) || connection.getConnectionSource(aDeviceType).getPage(aDeviceType) != sourcePage || connection.getConnectionDest(aDeviceType).getPage(aDeviceType) != destPage || connection.isForAllDeviceTypes() != isForAllDeviceTypes) continue;
            return true;
        }
        return false;
    }

    public boolean shouldRun() {
        DamaskUtils.checkValidArgument(this.source.getInteractionGraph() == this.dest.getInteractionGraph(), "source and dest of new connection must be in the same graph");
        this.graph = this.source.getInteractionGraph();
        if (this.source instanceof Page && this.dest instanceof Page) {
            Dialog sourceDialog = ((Page)this.source).getDialog();
            Dialog destDialog = ((Page)this.dest).getDialog();
            if (this.addToAllDeviceTypes) {
                if (sourceDialog.getDeviceType() != DeviceType.ALL || destDialog.getDeviceType() != DeviceType.ALL) {
                    return false;
                }
                return !this.navConnectionExists((Page)this.source, (Page)this.dest, true);
            }
            if (this.getOrgConnection((Page)this.source, (Page)this.dest, true) != null) {
                return false;
            }
            if (this.navConnectionExists((Page)this.source, (Page)this.dest, true)) {
                return false;
            }
            return !this.navConnectionExists((Page)this.source, (Page)this.dest, false);
        }
        if (this.addToAllDeviceTypes) {
            Control sourceControl = (Control)this.source;
            if (sourceControl.getDeviceType() != DeviceType.ALL) {
                return false;
            }
            return !(this.dest instanceof Page ? ((Page)this.dest).getDialog().getDeviceType() != DeviceType.ALL : ((Control)this.dest).getDeviceType() != DeviceType.ALL);
        }
        Control sourceControl = (Control)this.source;
        if (sourceControl.getDeviceType() == DeviceType.ALL) {
            return false;
        }
        NavConnection existingConnection = ((Control)this.source).getOutConnection(this.deviceType, this.addToAllDeviceTypes, this.userEvent, this.condition);
        return existingConnection == null || !existingConnection.isForAllDeviceTypes();
    }

    private void addOrgConnectionForAllDevices() {
        Page sourcePage = (Page)this.source;
        Page destPage = (Page)this.dest;
        DamaskUtils.checkValidArgument(sourcePage.getDialog().getDeviceType() == DeviceType.ALL, "The dialog of the source page " + sourcePage + " should support all device types, not just " + sourcePage.getDialog().getDeviceType());
        DamaskUtils.checkValidArgument(destPage.getDialog().getDeviceType() == DeviceType.ALL, "The dialog of the source page " + destPage + " should support all device types, not just " + destPage.getDialog().getDeviceType());
        OrgConnection existingConnection = this.getOrgConnection(sourcePage, destPage, this.addToAllDeviceTypes);
        if (existingConnection != null) {
            this.changeConnectionShape(existingConnection, this.deviceType, this.generalPathForDeviceType);
            return;
        }
        this.connection = new OrgConnection(this.deviceType, this.addToAllDeviceTypes, sourcePage, destPage, this.generalPathForDeviceType);
        this.setDefaultConnectionShapes(this.connection);
        Iterator i = this.connection.getDeviceTypesVisibleTo().iterator();
        block0: while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            Page sourcePageForADeviceType = (Page)this.connection.getConnectionSource(aDeviceType);
            Page destPageForADeviceType = (Page)this.connection.getConnectionDest(aDeviceType);
            HashSet sourcePageForADeviceTypeOutConnections = new HashSet(sourcePageForADeviceType.getOutConnections());
            Iterator j = sourcePageForADeviceTypeOutConnections.iterator();
            while (j.hasNext()) {
                OrgConnection outConnection = (OrgConnection)j.next();
                if (outConnection.getDest(aDeviceType) != destPageForADeviceType || outConnection.isForAllDeviceTypes()) continue;
                this.connection.setShape(aDeviceType, outConnection.getShape(aDeviceType));
                this.removeConnectionAndSaveInfo(outConnection);
                continue block0;
            }
        }
        this.graph.add(this.connection);
    }

    private void addOrgConnectionForOneDevice() {
        Page sourcePage = (Page)this.source;
        Page destPage = (Page)this.dest;
        DamaskUtils.checkValidArgument(sourcePage.getDeviceType() == this.deviceType, "The device type of this command " + this.deviceType + " must match the device type of the source " + this.source + ", which is " + sourcePage.getDeviceType());
        DamaskUtils.checkValidArgument(destPage.getDeviceType() == this.deviceType, "The device type of this command " + this.deviceType + " must match the device type of the destination " + this.dest + ", which is " + destPage.getDeviceType());
        OrgConnection existingConnection = this.getOrgConnection(sourcePage, destPage, this.addToAllDeviceTypes);
        if (existingConnection != null) {
            this.changeConnectionShape(existingConnection, this.deviceType, this.generalPathForDeviceType);
            return;
        }
        this.connection = new OrgConnection(this.deviceType, this.addToAllDeviceTypes, sourcePage, destPage, this.generalPathForDeviceType);
        this.graph.add(this.connection);
    }

    private void addNavConnectionForAllDevices() {
        DeviceType aDeviceType;
        Control sourceControl = (Control)this.source;
        Control destControl = this.dest instanceof Control ? (Control)this.dest : null;
        Page destPage = this.dest.getPage(this.deviceType);
        DamaskUtils.checkValidArgument(sourceControl.getDeviceType() == DeviceType.ALL, "The device type of this command " + this.deviceType + " must match the device type of the source " + sourceControl + ", which is " + sourceControl.getDeviceType());
        if (destControl == null) {
            DamaskUtils.checkValidArgument(destPage.getDialog().getDeviceType() == DeviceType.ALL, "The device type of the destination " + this.dest + " must be DeviceType.ALL, not " + destPage.getDialog().getDeviceType());
        } else {
            DamaskUtils.checkValidArgument(destControl.getDeviceType() == DeviceType.ALL, "The device type of the destination " + this.dest + " must be DeviceType.ALL, not " + destControl.getDeviceType());
        }
        Connection existingConnection = sourceControl.getOutConnection(this.deviceType, this.userEvent, this.condition);
        if (existingConnection != null && existingConnection.getDest(this.deviceType) == this.dest && existingConnection.isForAllDeviceTypes()) {
            this.changeConnectionShape(existingConnection, this.deviceType, this.generalPathForDeviceType);
            return;
        }
        existingConnection = this.getOrgConnection(this.source.getPage(this.deviceType), this.dest.getPage(this.deviceType), true);
        if (existingConnection != null) {
            this.removeConnectionAndSaveInfo(existingConnection);
        }
        HashMap<DeviceType, GeneralPath> existingPaths = new HashMap<DeviceType, GeneralPath>();
        Iterator<Object> i = sourceControl.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            aDeviceType = (DeviceType)i.next();
            Connection existingConnection2 = this.getOrgConnection(this.source.getDialog().getFirstPage(aDeviceType), this.dest.getDialog().getFirstPage(aDeviceType), false);
            if (existingConnection2 != null) {
                this.removeConnectionAndSaveInfo(existingConnection2);
            }
            if ((existingConnection2 = sourceControl.getOutConnection(this.deviceType, this.addToAllDeviceTypes, this.userEvent, this.condition)) == null || !existingConnection2.isForAllDeviceTypes()) continue;
            if (((NavConnection)existingConnection2).getDest(this.deviceType) == this.dest) {
                existingPaths.put(aDeviceType, existingConnection2.getShape(aDeviceType));
            }
            this.removeConnectionAndSaveInfo(existingConnection2);
        }
        if (sourceControl instanceof Content) {
            this.replaceContentWithTrigger((Content)sourceControl);
        }
        this.connection = new NavConnection(this.deviceType, this.addToAllDeviceTypes, this.sourceTrigger == null ? sourceControl : this.sourceTrigger, this.sourceTrigger == null ? this.userEvent : this.userEvent.createCopy(this.sourceTrigger), this.condition, this.dest, this.generalPathForDeviceType);
        this.graph.add(this.connection);
        this.setDefaultConnectionShapes(this.connection);
        i = existingPaths.keySet().iterator();
        while (i.hasNext()) {
            aDeviceType = (DeviceType)i.next();
            this.connection.setShape(aDeviceType, (GeneralPath)existingPaths.get(aDeviceType));
        }
    }

    private void addNavConnectionForOneDevice() {
        Control sourceControl = (Control)this.source;
        Control destControl = this.dest instanceof Control ? (Control)this.dest : null;
        Page destPage = this.dest.getPage(this.deviceType);
        DeviceType sourceDeviceType = sourceControl.getDeviceType();
        DeviceType destDeviceType = destControl == null ? destPage.getDeviceType() : destControl.getDeviceType();
        DamaskUtils.checkValidArgument(sourceDeviceType == DeviceType.ALL || sourceDeviceType == this.deviceType, "The device type of this command " + this.deviceType + " must be compatible with the device type of the source " + sourceControl + ", which is " + sourceControl.getDeviceType());
        DamaskUtils.checkValidArgument(destDeviceType == DeviceType.ALL || destDeviceType == this.deviceType, "The device type of this command " + this.deviceType + " must be compatible with the device type of the destination " + this.dest + ", which is " + destDeviceType);
        Connection existingConnection = this.getOrgConnection(this.source.getDialog().getFirstPage(this.deviceType), this.dest.getDialog().getFirstPage(this.deviceType), false);
        if (existingConnection != null) {
            this.removeConnectionAndSaveInfo(existingConnection);
        }
        if ((existingConnection = sourceControl.getOutConnection(this.deviceType, this.addToAllDeviceTypes, this.userEvent, this.condition)) != null && !existingConnection.isForAllDeviceTypes()) {
            if (((NavConnection)existingConnection).getDest(this.deviceType) == this.dest) {
                this.changeConnectionShape(existingConnection, this.deviceType, this.generalPathForDeviceType);
                return;
            }
            this.removeConnectionAndSaveInfo(existingConnection);
        }
        if (sourceControl instanceof Content) {
            this.replaceContentWithTrigger((Content)sourceControl);
        }
        this.connection = new NavConnection(this.deviceType, this.addToAllDeviceTypes, this.sourceTrigger == null ? sourceControl : this.sourceTrigger, this.sourceTrigger == null ? this.userEvent : this.userEvent.createCopy(this.sourceTrigger), this.condition, this.dest, this.generalPathForDeviceType);
        this.graph.add(this.connection);
        this.setDefaultConnectionShapes(this.connection);
    }

    public void run() {
        DamaskUtils.checkValidArgument(this.source.getInteractionGraph() == this.dest.getInteractionGraph(), "source and dest of new connection must be in the same graph");
        this.graph = this.source.getInteractionGraph();
        this.connection = null;
        this.removedConnections.clear();
        this.changedShapeConnections.clear();
        if (this.source instanceof Page) {
            if (this.addToAllDeviceTypes) {
                this.addOrgConnectionForAllDevices();
            } else {
                this.addOrgConnectionForOneDevice();
            }
        } else if (this.addToAllDeviceTypes) {
            this.addNavConnectionForAllDevices();
        } else {
            this.addNavConnectionForOneDevice();
        }
        this.newConnectionInfo = this.connection != null ? new ConnectionInfo(this.connection) : null;
    }

    public void redo() {
        this.run();
    }

    public void undo() {
        if (this.newConnectionInfo != null) {
            Connection connectionToRemove = this.newConnectionInfo.findConnection(this.graph);
            this.graph.remove(connectionToRemove);
            connectionToRemove.dispose();
        }
        if (this.sourceTrigger != null) {
            Content sourceContent = (Content)this.source;
            this.sourceTrigger.getDialog().addControlAfter(this.sourceTrigger, sourceContent);
            this.sourceTrigger.getDialog().removeControl(this.sourceTrigger);
            if (this.splitVoicePage != null) {
                this.voicePageWithTrigger.merge(this.splitVoicePage);
            }
        }
        if (this.voiceContentBeforeSourceTrigger != null) {
            this.voiceContentBeforeSourceTrigger.getDialog().removeControl(this.voiceContentBeforeSourceTrigger);
        }
        Iterator i = this.removedConnections.iterator();
        while (i.hasNext()) {
            ConnectionInfo removedConnectionInfo = (ConnectionInfo)i.next();
            Connection restoredConnection = removedConnectionInfo.createConnection();
            this.graph.add(restoredConnection);
        }
        i = this.getConnectionsForShapeRestoration().iterator();
        while (i.hasNext()) {
            Connection restoredConnection = (Connection)i.next();
            Iterator j = this.getDeviceTypesForShapeRestoration().iterator();
            while (j.hasNext()) {
                DeviceType aDeviceType = (DeviceType)j.next();
                this.restoreConnectionShape(restoredConnection, aDeviceType);
            }
        }
    }
}

