/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.lib.util.ClassLib;
import edu.berkeley.guir.lib.util.StringLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class InteractionSubgraph
implements Cloneable {
    private List dialogs = new ArrayList();
    private List connections = new ArrayList();
    private List patternInstances = new ArrayList();
    private List templates = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.InteractionSubgraph");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public InteractionSubgraph() {
    }

    public InteractionSubgraph(InteractionGraph graph2) {
        ArrayList dialogs2 = new ArrayList(graph2.getDialogs());
        Iterator i = dialogs2.iterator();
        while (i.hasNext()) {
            Dialog d = (Dialog)i.next();
            this.add(d);
        }
        ArrayList connections2 = new ArrayList(graph2.getConnections());
        Iterator i2 = connections2.iterator();
        while (i2.hasNext()) {
            Connection c = (Connection)i2.next();
            this.add(c);
        }
        ArrayList patternInstances2 = new ArrayList(graph2.getPatternInstances());
        Iterator i3 = patternInstances2.iterator();
        while (i3.hasNext()) {
            PatternInstance pi = (PatternInstance)i3.next();
            this.add(pi);
        }
    }

    public void add(Dialog dialog) {
        this.dialogs.add(dialog);
    }

    public boolean remove(Dialog dialog) {
        int index = this.dialogs.indexOf(dialog);
        if (index != -1) {
            this.dialogs.remove(index);
            return true;
        }
        return false;
    }

    public List getDialogs() {
        return DamaskUtils.unmodifiableList(this.dialogs);
    }

    public List getDialogs(DeviceType deviceType) {
        ArrayList<Dialog> dialogsToReturn = new ArrayList<Dialog>();
        Iterator i = this.getDialogs().iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            List pagesForDialog = dialog.getPages(deviceType);
            if (pagesForDialog.isEmpty()) continue;
            dialogsToReturn.add(dialog);
        }
        return dialogsToReturn;
    }

    public void add(Connection connection) {
        this.connections.add(connection);
    }

    public boolean remove(Connection connection) {
        int index = this.connections.indexOf(connection);
        if (index != -1) {
            this.connections.remove(index);
            return true;
        }
        return false;
    }

    public Collection getConnections() {
        return DamaskUtils.unmodifiableCollection(this.connections);
    }

    public Collection getConnections(DeviceType deviceType) {
        HashSet<Connection> connectionsToReturn = new HashSet<Connection>();
        Iterator i = this.getConnections().iterator();
        while (i.hasNext()) {
            Connection c = (Connection)i.next();
            if (!c.isVisibleToDeviceType(deviceType)) continue;
            connectionsToReturn.add(c);
        }
        return connectionsToReturn;
    }

    public void add(PatternInstance p) {
        this.patternInstances.add(p);
    }

    public boolean remove(PatternInstance p) {
        int index = this.patternInstances.indexOf(p);
        if (index != -1) {
            this.patternInstances.remove(index);
            return true;
        }
        return false;
    }

    public Collection getPatternInstances() {
        return DamaskUtils.unmodifiableCollection(this.patternInstances);
    }

    public void addTemplate(Dialog template) {
        this.templates.add(template);
    }

    public boolean removeTemplate(Dialog template) {
        int index = this.templates.indexOf(template);
        if (index != -1) {
            this.templates.remove(index);
            return true;
        }
        return false;
    }

    public List getTemplates() {
        return DamaskUtils.unmodifiableList(this.templates);
    }

    public List getTemplates(DeviceType deviceType) {
        ArrayList<Dialog> templatesToReturn = new ArrayList<Dialog>();
        Iterator i = this.getTemplates().iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            List pagesForDialog = dialog.getPages(deviceType);
            if (pagesForDialog.isEmpty()) continue;
            templatesToReturn.add(dialog);
        }
        return templatesToReturn;
    }

    public Dialog getDefaultTemplate() {
        return (Dialog)this.templates.get(0);
    }

    public Page getDefaultTemplatePage(DeviceType deviceType) {
        return this.getDefaultTemplate().getFirstPage(deviceType);
    }

    public boolean isTemplate(Dialog dialog) {
        return this.getTemplates().contains(dialog);
    }

    public boolean isTemplate(Page page) {
        return this.isTemplate(page.getDialog());
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(ClassLib.getShortClassName(this)) + "\n");
        Iterator i = Damask.getSupportedDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType device = (DeviceType)i.next();
            sb.append(device + ":\n");
            sb.append(" -Dialogs: " + this.getDialogs(device).size() + "\n");
            sb.append(this.dialogsToString(device));
            sb.append(" -Connections: " + this.getConnections(device).size() + "\n");
            sb.append(this.connectionsToString(device));
            sb.append("\n");
        }
        sb.append("* Pattern instances: " + this.getPatternInstances().size() + "\n");
        sb.append(this.patternInstancesToString());
        return sb.toString();
    }

    public String toString(DeviceType deviceType) {
        if (!$assertionsDisabled && deviceType == DeviceType.ALL) {
            throw new AssertionError((Object)"Device cannot be ALL");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getClass().toString()) + "\n");
        sb.append("* Dialogs for " + deviceType + ": " + this.getDialogs(deviceType).size() + "\n");
        sb.append(this.dialogsToString(deviceType));
        sb.append("* Connections: " + this.getConnections(deviceType).size() + "\n");
        sb.append(this.connectionsToString(deviceType));
        sb.append("* Pattern instances: " + this.getPatternInstances().size() + "\n");
        sb.append(this.patternInstancesToString());
        return sb.toString();
    }

    private String dialogsToString(DeviceType deviceType) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getDialogs(deviceType).iterator();
        while (i.hasNext()) {
            Dialog d = (Dialog)i.next();
            sb.append(d.toLongString(1, deviceType));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String connectionsToString(DeviceType deviceType) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getConnections(deviceType).iterator();
        while (i.hasNext()) {
            Connection c = (Connection)i.next();
            sb.append(StringLib.spaces(DamaskUtils.INDENT_SPACES));
            sb.append(c.toLongString(1, deviceType));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String patternInstancesToString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getPatternInstances().iterator();
        while (i.hasNext()) {
            PatternInstance pi = (PatternInstance)i.next();
            sb.append(StringLib.spaces(DamaskUtils.INDENT_SPACES));
            sb.append(pi.toLongString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

