/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionSubgraph;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.ElementContainerSource;
import edu.berkeley.guir.damask.event.InteractionGraphListener;
import edu.berkeley.guir.damask.event.InteractionGraphSource;
import edu.berkeley.guir.damask.pattern.Pattern;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.damask.pattern.PatternInstanceMember;
import edu.berkeley.guir.lib.util.ClassLib;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InteractionGraph
implements Cloneable {
    private List dialogs = new ArrayList();
    private List connections = new ArrayList();
    private List patternInstances = new ArrayList();
    private List templates = new ArrayList();
    private Map homePages = new HashMap();
    private InteractionGraphSource graphEventSource = new InteractionGraphSource();
    private ElementContainerSource containerEventSource = new ElementContainerSource();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.InteractionGraph");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public InteractionGraph() {
        Content defaultTitle = new Content(DeviceType.ALL, "Default");
        defaultTitle.setTextSize(DeviceType.ALL, 12);
        TemplateDialog defaultTemplate = new TemplateDialog(DeviceType.ALL, defaultTitle);
        this.addTemplate(defaultTemplate);
    }

    public void dispose() {
        Iterator i = new ArrayList(this.patternInstances).iterator();
        while (i.hasNext()) {
            PatternInstance pi = (PatternInstance)i.next();
            this.remove(pi);
            pi.dispose();
        }
        i = new ArrayList(this.connections).iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            this.remove(connection);
            connection.dispose();
        }
        i = new ArrayList(this.dialogs).iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            this.remove(dialog);
            dialog.dispose();
        }
        i = new ArrayList(this.templates).iterator();
        while (i.hasNext()) {
            TemplateDialog template = (TemplateDialog)i.next();
            this.removeTemplate(template);
            template.dispose();
        }
    }

    public void add(Dialog dialog) {
        this.add(dialog, true);
    }

    public void add(Dialog dialog, boolean applyDefaultTemplate) {
        InteractionGraph oldGraph = dialog.getInteractionGraph();
        if (oldGraph != null) {
            oldGraph.remove(dialog);
        }
        dialog.setInteractionGraph(this);
        this.dialogs.add(dialog);
        this.fireElementAdded(this.dialogs.size() - 1, dialog);
        Iterator i = dialog.getDeviceTypesVisibleTo().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            if (applyDefaultTemplate) {
                Iterator j = dialog.getPages(aDeviceType).iterator();
                while (j.hasNext()) {
                    Page aPage = (Page)j.next();
                    aPage.addTemplate(this.getDefaultTemplatePage(aDeviceType));
                }
            }
            if (this.getHomePage(aDeviceType) != null) continue;
            this.setHomePage(aDeviceType, dialog.getFirstPage(aDeviceType));
        }
    }

    public boolean remove(Dialog dialog) {
        int index = this.dialogs.indexOf(dialog);
        if (index != -1) {
            Iterator i = Damask.getSupportedDeviceTypes().iterator();
            block0: while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                Page aHomePage = this.getHomePage(aDeviceType);
                if (aHomePage == null || aHomePage.getDialog() != dialog) continue;
                this.setHomePage(aDeviceType, null);
                Iterator j = this.getDialogs().iterator();
                while (j.hasNext()) {
                    Dialog aDialog = (Dialog)j.next();
                    if (aDialog == dialog || !aDialog.isVisibleToDeviceType(aDeviceType)) continue;
                    this.setHomePage(aDeviceType, aDialog.getFirstPage(aDeviceType));
                    continue block0;
                }
            }
            this.dialogs.remove(index);
            dialog.setInteractionGraph(null);
            this.fireElementRemoved(index, dialog);
            return true;
        }
        return false;
    }

    public List getDialogs() {
        return DamaskUtils.unmodifiableList(this.dialogs);
    }

    public List getDialogs(DeviceType deviceType) {
        ArrayList<Dialog> dialogsToReturn = new ArrayList<Dialog>();
        Iterator i = this.getDialogs().iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            List pagesForDialog = dialog.getPages(deviceType);
            if (pagesForDialog.isEmpty()) continue;
            dialogsToReturn.add(dialog);
        }
        return dialogsToReturn;
    }

    public Page getHomePage(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        return (Page)this.homePages.get(deviceType);
    }

    public void setHomePage(DeviceType deviceType, Page page) {
        deviceType.verifyTypeIsNotAll();
        if (page == null) {
            this.homePages.remove(deviceType);
        } else {
            DamaskUtils.checkValidArgument(deviceType == page.getDeviceType(), "The device type of " + page + " (" + page.getDeviceType() + ") does not match " + deviceType);
            this.homePages.put(deviceType, page);
        }
        this.fireHomePageChanged(deviceType);
    }

    public void add(Connection connection) {
        InteractionGraph oldGraph = connection.getInteractionGraph();
        if (oldGraph != null) {
            oldGraph.remove(connection);
        }
        connection.setInteractionGraph(this);
        this.connections.add(connection);
        this.fireElementAdded(this.connections.size() - 1, connection);
    }

    public boolean remove(Connection connection) {
        int index = this.connections.indexOf(connection);
        if (index != -1) {
            this.connections.remove(index);
            connection.setInteractionGraph(null);
            this.fireElementRemoved(index, connection);
            return true;
        }
        return false;
    }

    public Collection getConnections() {
        return DamaskUtils.unmodifiableCollection(this.connections);
    }

    public Collection getConnections(DeviceType deviceType) {
        HashSet<Connection> connectionsToReturn = new HashSet<Connection>();
        Iterator i = this.getConnections().iterator();
        while (i.hasNext()) {
            Connection c = (Connection)i.next();
            if (!c.isVisibleToDeviceType(deviceType)) continue;
            connectionsToReturn.add(c);
        }
        return connectionsToReturn;
    }

    public void add(PatternInstance p) {
        InteractionGraph oldGraph = p.getInteractionGraph();
        if (oldGraph != null) {
            oldGraph.remove(p);
        }
        p.setInteractionGraph(this);
        this.patternInstances.add(p);
        this.fireElementAdded(this.patternInstances.size() - 1, p);
    }

    public boolean remove(PatternInstance p) {
        int index = this.patternInstances.indexOf(p);
        if (index != -1) {
            this.patternInstances.remove(index);
            p.setInteractionGraph(null);
            this.fireElementRemoved(index, p);
            return true;
        }
        return false;
    }

    public Collection getPatternInstances() {
        return DamaskUtils.unmodifiableCollection(this.patternInstances);
    }

    public void addTemplate(TemplateDialog template) {
        InteractionGraph oldGraph = template.getInteractionGraph();
        if (oldGraph != null) {
            oldGraph.remove(template);
        }
        template.setInteractionGraph(this);
        this.templates.add(template);
        this.fireElementAdded(this.templates.size() - 1, template);
    }

    public boolean removeTemplate(TemplateDialog template) {
        int index = this.templates.indexOf(template);
        if (index != -1) {
            Iterator i = this.getDialogs().iterator();
            while (i.hasNext()) {
                Dialog dialog = (Dialog)i.next();
                Iterator j = dialog.getDeviceTypesVisibleTo().iterator();
                while (j.hasNext()) {
                    DeviceType deviceType = (DeviceType)j.next();
                    Iterator k = dialog.getPages(deviceType).iterator();
                    while (k.hasNext()) {
                        Page pageTemplate;
                        Page page = (Page)k.next();
                        ArrayList<Page> templatesToRemove = new ArrayList<Page>();
                        Iterator m = page.getTemplates().iterator();
                        while (m.hasNext()) {
                            pageTemplate = (Page)m.next();
                            if (pageTemplate.getDialog() != template) continue;
                            templatesToRemove.add(pageTemplate);
                        }
                        m = templatesToRemove.iterator();
                        while (m.hasNext()) {
                            pageTemplate = (Page)m.next();
                            page.removeTemplate(pageTemplate);
                        }
                    }
                }
            }
            this.templates.remove(index);
            template.setInteractionGraph(null);
            this.fireElementRemoved(index, template);
            return true;
        }
        return false;
    }

    public List getTemplates() {
        return DamaskUtils.unmodifiableList(this.templates);
    }

    public List getTemplates(DeviceType deviceType) {
        ArrayList<TemplateDialog> templatesToReturn = new ArrayList<TemplateDialog>();
        Iterator i = this.getTemplates().iterator();
        while (i.hasNext()) {
            TemplateDialog dialog = (TemplateDialog)i.next();
            List pagesForDialog = dialog.getPages(deviceType);
            if (pagesForDialog.isEmpty()) continue;
            templatesToReturn.add(dialog);
        }
        return templatesToReturn;
    }

    public TemplateDialog getDefaultTemplate() {
        return (TemplateDialog)this.templates.get(0);
    }

    public Page getDefaultTemplatePage(DeviceType deviceType) {
        return this.getDefaultTemplate().getFirstPage(deviceType);
    }

    private void createClone(InteractionGraph clone, Collection dialogsToClone, Collection connectionsToClone, Collection patternInstancesToClone) {
        clone.containerEventSource = new ElementContainerSource();
        clone.graphEventSource = new InteractionGraphSource();
        clone.dialogs = new ArrayList();
        clone.connections = new ArrayList();
        clone.patternInstances = new ArrayList();
        Iterator i = dialogsToClone.iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            Dialog cloneDialog = (Dialog)dialog.clone();
            clone.add(cloneDialog);
        }
        i = connectionsToClone.iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            Connection cloneConnection = (Connection)connection.clone();
            clone.add(cloneConnection);
        }
        i = patternInstancesToClone.iterator();
        while (i.hasNext()) {
            PatternInstance patternInstance = (PatternInstance)i.next();
            PatternInstance clonePatternInstance = (PatternInstance)patternInstance.clone();
            clone.add(clonePatternInstance);
        }
        i = clone.getPatternInstances().iterator();
        while (i.hasNext()) {
            PatternInstance pi = (PatternInstance)i.next();
            Iterator j = new HashSet(pi.getMembers()).iterator();
            while (j.hasNext()) {
                PatternInstanceMember m = (PatternInstanceMember)j.next();
                pi.remove(m);
                if (!$assertionsDisabled && m.getMostRecentCloneIfAlive() == null) {
                    throw new AssertionError((Object)"clone of d should still be alive");
                }
                pi.add((PatternInstanceMember)m.getMostRecentCloneIfAlive());
            }
        }
    }

    public Object clone() {
        try {
            InteractionGraph clone = (InteractionGraph)super.clone();
            this.createClone(clone, this.getDialogs(), this.getConnections(), this.getPatternInstances());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Object doesn't support clone - yeah right");
        }
    }

    protected InteractionGraph createPartialClone(Collection dialogsToClone, Collection connectionsToClone, Collection patternInstancesToClone) {
        InteractionGraph newGraph = new InteractionGraph();
        this.createClone(newGraph, dialogsToClone, connectionsToClone, patternInstancesToClone);
        return newGraph;
    }

    public void merge(InteractionGraph graph2) {
        ArrayList dialogs2 = new ArrayList(graph2.getDialogs());
        Iterator i = dialogs2.iterator();
        while (i.hasNext()) {
            Dialog d = (Dialog)i.next();
            this.add(d);
        }
        ArrayList connections2 = new ArrayList(graph2.getConnections());
        Iterator i2 = connections2.iterator();
        while (i2.hasNext()) {
            Connection c = (Connection)i2.next();
            this.add(c);
        }
        ArrayList patternInstances2 = new ArrayList(graph2.getPatternInstances());
        Iterator i3 = patternInstances2.iterator();
        while (i3.hasNext()) {
            PatternInstance pi = (PatternInstance)i3.next();
            this.add(pi);
        }
    }

    public InteractionSubgraph mergePatternInstance(Pattern pattern, Page mergePatternPage, Point2D mergePoint, Page mergeGraphPage, Set newComponentsInMergeGraphDialog) {
        if (mergePatternPage != null && mergeGraphPage != null) {
            DamaskUtils.checkValidArgument(mergePatternPage.getDeviceType() == mergeGraphPage.getDeviceType(), "mergePatternPage and mergeGraphPage should have the same device type");
        }
        InteractionSubgraph subgraph = pattern.createPatternInstance(this);
        if (mergePatternPage != null) {
            Page mergeInstancePage = (Page)mergePatternPage.getMostRecentCloneIfAlive();
            if (!$assertionsDisabled && mergeInstancePage == null) {
                throw new AssertionError((Object)"mergePatternPage's clone should still be alive");
            }
            Dialog mergeInstanceDialog = mergeInstancePage.getDialog();
            Dialog mergeGraphDialog = mergeGraphPage == null ? null : mergeGraphPage.getDialog();
            Rectangle2D mergeInstanceRect = mergeInstancePage.localToGlobal(mergeInstancePage.getDeviceType(), mergeInstancePage.getBounds());
            Iterator i = Damask.getSupportedDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType deviceType = (DeviceType)i.next();
                double dx = Double.NaN;
                double dy = Double.NaN;
                if (mergeGraphDialog != null) {
                    if (mergeGraphDialog.isVisibleToDeviceType(deviceType)) {
                        Page mergeGraphPageForDeviceType = mergeGraphPage.getDeviceType() == deviceType ? mergeGraphPage : mergeGraphDialog.getFirstPage(deviceType);
                        Rectangle2D mergeGraphRect = mergeGraphPageForDeviceType.localToGlobal(mergeGraphPageForDeviceType.getDeviceType(), mergeGraphPageForDeviceType.getBounds());
                        dx = mergeGraphRect.getX() - mergeInstanceRect.getX();
                        dy = mergeGraphRect.getY() - mergeInstanceRect.getY();
                    }
                } else if (mergePoint != null) {
                    dx = mergePoint.getX() - mergeInstanceRect.getX();
                    dy = mergePoint.getY() - mergeInstanceRect.getY();
                }
                if (dx == Double.NaN || dy == Double.NaN) continue;
                AffineTransform translate = AffineTransform.getTranslateInstance(dx, dy);
                Iterator j = subgraph.getDialogs().iterator();
                while (j.hasNext()) {
                    Dialog dialog = (Dialog)j.next();
                    if (deviceType == DeviceType.VOICE) {
                        AffineTransform dialogTransform = dialog.getTransform(deviceType);
                        dialogTransform.preConcatenate(translate);
                        dialog.setTransform(deviceType, dialogTransform);
                        continue;
                    }
                    Iterator k = dialog.getPages(deviceType).iterator();
                    while (k.hasNext()) {
                        Page page = (Page)k.next();
                        AffineTransform pageTransform = page.getTransform();
                        pageTransform.preConcatenate(translate);
                        page.setTransform(pageTransform);
                    }
                }
            }
            if (mergeGraphDialog != null) {
                i = mergeInstanceDialog.getDeviceTypesVisibleTo().iterator();
                while (i.hasNext()) {
                    DeviceType aDeviceType = (DeviceType)i.next();
                    Iterator j = mergeInstanceDialog.getPages(aDeviceType).iterator();
                    while (j.hasNext()) {
                        Page aPage = (Page)j.next();
                        Iterator k = aPage.getRegions().iterator();
                        while (k.hasNext()) {
                            PageRegion aRegion = (PageRegion)k.next();
                            newComponentsInMergeGraphDialog.addAll(aRegion.getControls());
                        }
                    }
                }
                newComponentsInMergeGraphDialog.addAll(mergeInstanceDialog.getGroups());
                mergeGraphDialog.merge(mergeInstanceDialog);
            }
        }
        Iterator i = subgraph.getConnections().iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            Iterator j = connection.getDeviceTypesVisibleTo().iterator();
            while (j.hasNext()) {
                DeviceType deviceType = (DeviceType)j.next();
                connection.refresh(deviceType);
            }
        }
        return subgraph;
    }

    public void addInteractionGraphListener(InteractionGraphListener listener) {
        this.graphEventSource.addInteractionGraphListener(listener);
    }

    public void removeInteractionGraphListener(InteractionGraphListener listener) {
        this.graphEventSource.removeInteractionGraphListener(listener);
    }

    private void fireHomePageChanged(DeviceType deviceType) {
        this.graphEventSource.fireHomePageChanged(this, deviceType);
    }

    public void addElementContainerListener(ElementContainerListener listener) {
        this.containerEventSource.addElementContainerListener(listener);
    }

    public void removeElementContainerListener(ElementContainerListener listener) {
        this.containerEventSource.removeElementContainerListener(listener);
    }

    private void fireElementAdded(int index, InteractionElement e) {
        this.containerEventSource.fireElementAdded(this, null, index, e);
    }

    private void fireElementRemoved(int index, InteractionElement e) {
        this.containerEventSource.fireElementRemoved(this, null, index, e);
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(ClassLib.getShortClassName(this)) + "\n");
        Iterator i = Damask.getSupportedDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType device = (DeviceType)i.next();
            sb.append(device + ":\n");
            sb.append(" -Dialogs: " + this.getDialogs(device).size() + "\n");
            sb.append(this.dialogsToString(device));
            sb.append(" -Connections: " + this.getConnections(device).size() + "\n");
            sb.append(this.connectionsToString(device));
            sb.append("\n");
        }
        sb.append("* Pattern instances: " + this.getPatternInstances().size() + "\n");
        sb.append(this.patternInstancesToString());
        return sb.toString();
    }

    public String toString(DeviceType deviceType) {
        if (!$assertionsDisabled && deviceType == DeviceType.ALL) {
            throw new AssertionError((Object)"Device cannot be ALL");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getClass().toString()) + "\n");
        sb.append("* Dialogs for " + deviceType + ": " + this.getDialogs(deviceType).size() + "\n");
        sb.append(this.dialogsToString(deviceType));
        sb.append("* Connections: " + this.getConnections(deviceType).size() + "\n");
        sb.append(this.connectionsToString(deviceType));
        sb.append("* Pattern instances: " + this.getPatternInstances().size() + "\n");
        sb.append(this.patternInstancesToString());
        return sb.toString();
    }

    private String dialogsToString(DeviceType deviceType) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getDialogs(deviceType).iterator();
        while (i.hasNext()) {
            Dialog d = (Dialog)i.next();
            sb.append(d.toLongString(1, deviceType));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String connectionsToString(DeviceType deviceType) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getConnections(deviceType).iterator();
        while (i.hasNext()) {
            Connection c = (Connection)i.next();
            sb.append(StringLib.spaces(DamaskUtils.INDENT_SPACES));
            sb.append(c.toLongString(1, deviceType));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String patternInstancesToString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getPatternInstances().iterator();
        while (i.hasNext()) {
            PatternInstance pi = (PatternInstance)i.next();
            sb.append(StringLib.spaces(DamaskUtils.INDENT_SPACES));
            sb.append(pi.toLongString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

