/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.Orientation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DeviceType {
    public static final int CENTER_INSET = -1;
    private final String name;
    private final int width;
    private final int height;
    private final int preferredContentHeight;
    private final int gridWidth;
    private final int gridHeight;
    private final int groupDefaultWidth;
    private final int groupDefaultHeight;
    private final int defaultFontSize;
    private final Map insets = new HashMap();
    private final Map orientations = new HashMap();
    private final boolean visual;
    private final boolean audio;
    private final Set regionNames = new HashSet();
    public static final DeviceType ALL = new DeviceType("All", 0, 0, 0, 0, 0, 0, null, 0, null, 0, null, 0, null, 0, null, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
    public static final DeviceType DESKTOP = new DeviceType("Desktop", 800, 600, 120, 40, 80, 80, Orientation.VERTICAL, 120, Orientation.HORIZONTAL, 60, Orientation.HORIZONTAL, 120, Orientation.VERTICAL, 120, Orientation.VERTICAL, Integer.MAX_VALUE, 12, true, true);
    public static final DeviceType SMARTPHONE = new DeviceType("Smartphone", 180, 215, 180, 20, 180, 20, Orientation.VERTICAL, 50, Orientation.VERTICAL, 50, Orientation.VERTICAL, 0, Orientation.VERTICAL, 0, Orientation.VERTICAL, 19, 12, true, true);
    public static final DeviceType VOICE = new DeviceType("Voice", 500, 600, 0, 0, 0, 0, Orientation.VERTICAL, 0, Orientation.VERTICAL, 0, Orientation.VERTICAL, 0, Orientation.VERTICAL, 0, Orientation.VERTICAL, Integer.MAX_VALUE, 12, false, true);

    private DeviceType(String name, int width, int height, int gridWidth, int gridHeight, int groupDefaultWidth, int groupDefaultHeight, Orientation centerOrientation, int northInset, Orientation northOrientation, int southInset, Orientation southOrientation, int eastInset, Orientation eastOrientation, int westInset, Orientation westOrientation, int preferredContentHeight, int defaultFontSize, boolean isVisual, boolean isAudio) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.groupDefaultWidth = groupDefaultWidth;
        this.groupDefaultHeight = groupDefaultHeight;
        this.insets.put(Direction.NORTH, new Integer(northInset));
        this.insets.put(Direction.SOUTH, new Integer(southInset));
        this.insets.put(Direction.EAST, new Integer(eastInset));
        this.insets.put(Direction.WEST, new Integer(westInset));
        this.insets.put(Direction.CENTER, new Integer(-1));
        this.orientations.put(Direction.NORTH, northOrientation);
        this.orientations.put(Direction.SOUTH, southOrientation);
        this.orientations.put(Direction.EAST, eastOrientation);
        this.orientations.put(Direction.WEST, westOrientation);
        this.orientations.put(Direction.CENTER, centerOrientation);
        this.preferredContentHeight = preferredContentHeight;
        this.defaultFontSize = defaultFontSize;
        this.visual = isVisual;
        this.audio = isAudio;
        this.regionNames.add(Direction.CENTER);
        this.regionNames.add(Direction.NORTH);
        this.regionNames.add(Direction.SOUTH);
        this.regionNames.add(Direction.WEST);
        this.regionNames.add(Direction.EAST);
    }

    public String getName() {
        return this.name;
    }

    public int getDefaultWidth() {
        return this.width;
    }

    public int getDefaultHeight() {
        return this.height;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public int getGroupDefaultWidth() {
        return this.groupDefaultWidth;
    }

    public int getGroupDefaultHeight() {
        return this.groupDefaultHeight;
    }

    public boolean isVisual() {
        return this.visual;
    }

    public boolean isAudio() {
        return this.audio;
    }

    public int getPreferredContentHeight() {
        return this.preferredContentHeight;
    }

    public int getDefaultFontSize() {
        return this.defaultFontSize;
    }

    public void verifyTypeIsNotAll() {
        DamaskUtils.checkValidArgument(this != ALL, "deviceType cannot be DeviceType.ALL");
    }

    public void verifyIsEqual(DeviceType deviceType) {
        DamaskUtils.checkValidArgument(this == deviceType, "The given device type " + deviceType + " does not match " + this);
    }

    public int getDefaultInset(Direction direction) {
        return (Integer)this.insets.get(direction);
    }

    public Orientation getOrientation(Direction direction) {
        return (Orientation)this.orientations.get(direction);
    }

    public Set getRegionNames() {
        return this.regionNames;
    }

    public String toString() {
        return this.name;
    }

    public Collection getSpecificDeviceTypes() {
        if (this == ALL) {
            return Damask.getSupportedDeviceTypes();
        }
        ArrayList<DeviceType> devices = new ArrayList<DeviceType>();
        devices.add(this);
        return devices;
    }
}

