/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.component.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeviceDependentContainer {
    private Map containees = new HashMap();

    public Set getDeviceTypes() {
        return Collections.unmodifiableSet(this.containees.keySet());
    }

    public List getContainees(DeviceType deviceType) {
        if (deviceType == DeviceType.ALL) {
            ArrayList containeesToReturn = new ArrayList();
            Iterator i = this.getDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                containeesToReturn.addAll(this.getContainees(aDeviceType));
            }
            return containeesToReturn;
        }
        return DamaskUtils.unmodifiableList((List)this.containees.get(deviceType));
    }

    public void add(DeviceType deviceType, InteractionElement containee) {
        this.add(deviceType, this.size(deviceType), containee);
    }

    public void add(DeviceType deviceType, int index, InteractionElement containee) {
        Collection devices = deviceType.getSpecificDeviceTypes();
        Iterator i = devices.iterator();
        while (i.hasNext()) {
            DeviceType aDevice = (DeviceType)i.next();
            ArrayList<InteractionElement> containeesForDevice = (ArrayList<InteractionElement>)this.containees.get(aDevice);
            if (containeesForDevice == null) {
                containeesForDevice = new ArrayList<InteractionElement>();
                this.containees.put(aDevice, containeesForDevice);
            }
            containeesForDevice.add(index, containee);
        }
    }

    public boolean remove(DeviceType deviceType, InteractionElement containee) {
        Collection devices = deviceType.getSpecificDeviceTypes();
        boolean removed = false;
        Iterator i = devices.iterator();
        while (i.hasNext()) {
            boolean removedForDevice;
            DeviceType aDevice = (DeviceType)i.next();
            List containeesForDevice = (List)this.containees.get(aDevice);
            if (containeesForDevice == null || !(removedForDevice = containeesForDevice.remove(containee))) continue;
            removed = true;
        }
        return removed;
    }

    public int indexOf(DeviceType deviceType, InteractionElement containee) {
        return ((List)this.containees.get(deviceType)).indexOf(containee);
    }

    public int size(DeviceType deviceType) {
        List list = (List)this.containees.get(deviceType);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public void clear() {
        this.containees.clear();
    }

    public Object clone() {
        try {
            DeviceDependentContainer clone = (DeviceDependentContainer)super.clone();
            HashMap<Object, Object> origToClone = new HashMap<Object, Object>();
            origToClone.put(this, clone);
            HashSet<Component> allChildren = new HashSet<Component>();
            Iterator i = this.getDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType device = (DeviceType)i.next();
                Iterator j = this.getContainees(device).iterator();
                while (j.hasNext()) {
                    Component containee = (Component)j.next();
                    allChildren.add(containee);
                }
            }
            i = allChildren.iterator();
            while (i.hasNext()) {
                Component containee = (Component)i.next();
                Component containeeClone = (Component)containee.clone();
                origToClone.put(containee, containeeClone);
            }
            Set cloneDevices = clone.getDeviceTypes();
            Iterator i2 = cloneDevices.iterator();
            while (i2.hasNext()) {
                DeviceType device = (DeviceType)i2.next();
                Iterator j = clone.getContainees(device).iterator();
                while (j.hasNext()) {
                    Component containee = (Component)j.next();
                    clone.add(device, containee);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Object doesn't support clone - yeah right");
        }
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType device = (DeviceType)i.next();
            sb.append("* " + device + "\n");
            sb.append(this.containeesToString(1, device));
        }
        return sb.toString();
    }

    public String toString(int indentLevel, DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        return this.containeesToString(indentLevel, deviceType);
    }

    private String containeesToString(int indentLevel, DeviceType deviceType) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getContainees(deviceType).iterator();
        while (i.hasNext()) {
            InteractionElement e = (InteractionElement)i.next();
            sb.append(e.toLongString(indentLevel, deviceType));
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

