/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.command.AddComponentToGroupCommand;
import edu.berkeley.guir.damask.command.AddControlCommand;
import edu.berkeley.guir.damask.command.AddGroupCommand;
import edu.berkeley.guir.damask.command.AddItemCommand;
import edu.berkeley.guir.damask.command.ChangePageRegionCommand;
import edu.berkeley.guir.damask.command.RemoveControlCommand;
import edu.berkeley.guir.damask.command.RemoveItemCommand;
import edu.berkeley.guir.damask.command.SetTransformCommand;
import edu.berkeley.guir.damask.command.SplitPageCommand;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.satin.command.MacroCommand;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class DamaskUtils {
    public static int INDENT_SPACES = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private DamaskUtils() {
    }

    public static Collection unmodifiableCollection(Collection collection) {
        if (collection != null) {
            return Collections.unmodifiableCollection(collection);
        }
        return Collections.EMPTY_LIST;
    }

    public static List unmodifiableList(List list) {
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.EMPTY_LIST;
    }

    private static void appendTwoDigit(StringBuffer sb, int x) {
        if (x < 10) {
            sb.append('0');
        }
        sb.append(x);
    }

    public static String dateToISO(long millis) {
        StringBuffer sb = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        sb.append(calendar.get(1));
        sb.append('-');
        DamaskUtils.appendTwoDigit(sb, calendar.get(2) + 1);
        sb.append('-');
        DamaskUtils.appendTwoDigit(sb, calendar.get(5));
        sb.append('T');
        DamaskUtils.appendTwoDigit(sb, calendar.get(11));
        sb.append(':');
        DamaskUtils.appendTwoDigit(sb, calendar.get(12));
        sb.append(':');
        DamaskUtils.appendTwoDigit(sb, calendar.get(13));
        return sb.toString();
    }

    public static Object defaultGet(Map map, Object key, Object defaultValue) {
        Object value;
        if (map.containsKey(key)) {
            value = map.get(key);
        } else {
            map.put(key, defaultValue);
            value = defaultValue;
        }
        return value;
    }

    public static void checkValidArgument(boolean cond, String message) {
        if (!cond) {
            throw new IllegalArgumentException(message);
        }
    }

    private static ComponentGroup getDeepestGroupAt(ComponentGroup possibleGroup, PageRegion region, Rectangle2D boundsInGroupCoords) throws NoninvertibleTransformException {
        ComponentGroup result = null;
        if (possibleGroup.getBoundsInPageRegion(region).contains(boundsInGroupCoords)) {
            result = possibleGroup;
            ComponentGroup nestedGroupResult = null;
            Iterator j = possibleGroup.getChildren(region.getDeviceType()).iterator();
            while (j.hasNext()) {
                Rectangle2D boundsInNestedGroupCoords;
                ComponentGroup nestedGroup;
                Component child = (Component)j.next();
                if (!(child instanceof ComponentGroup) || (nestedGroupResult = DamaskUtils.getDeepestGroupAt(nestedGroup = (ComponentGroup)child, region, boundsInNestedGroupCoords = GeomLib.transformRectangle(nestedGroup.getTransformInPageRegion(region).createInverse(), boundsInGroupCoords))) == null) continue;
                result = nestedGroupResult;
                break;
            }
        }
        return result;
    }

    public static ComponentGroup getDeepestGroupAt(PageRegion region, AffineTransform transform, Rectangle2D bounds, boolean forAllDeviceTypes) {
        try {
            Rectangle2D boundsInRegionCoords = GeomLib.transformRectangle(transform, bounds);
            ComponentGroup group = null;
            Iterator i = region.getPage().getDialog().getGroups().iterator();
            while (i.hasNext()) {
                Rectangle2D boundsInGroupCoords;
                ComponentGroup result;
                AffineTransform possibleGroupTransformInRegion;
                ComponentGroup possibleGroup = (ComponentGroup)i.next();
                if (possibleGroup.isForAllDeviceTypes() != forAllDeviceTypes || (possibleGroupTransformInRegion = possibleGroup.getTransformInPageRegion(region)) == null || (result = DamaskUtils.getDeepestGroupAt(possibleGroup, region, boundsInGroupCoords = GeomLib.transformRectangle(possibleGroupTransformInRegion.createInverse(), boundsInRegionCoords))) == null) continue;
                group = result;
                break;
            }
            return group;
        }
        catch (NoninvertibleTransformException e) {
            DamaskAppExceptionHandler.log(e);
            return null;
        }
    }

    public static Select findExistingSelect(PageRegion region, ComponentGroup group, DeviceType itemDeviceType, Class selectClass, Select.Style selectStyle) {
        Select selectToAddTo = null;
        Iterator i = region.getControls().iterator();
        while (i.hasNext()) {
            Select select;
            Control control = (Control)i.next();
            if (!selectClass.isInstance(control) || (select = (Select)control).getDeviceType() != itemDeviceType || select.getGroup() != group || select.getStyle(region.getDeviceType()) != selectStyle) continue;
            selectToAddTo = select;
            break;
        }
        return selectToAddTo;
    }

    public static Page[] splitVoicePageAfterTrigger(Trigger control) {
        PageRegion voicePageRegion = control.getPageRegion(DeviceType.VOICE);
        Page voicePageWithTrigger = voicePageRegion.getPage();
        List voiceControls = voicePageRegion.getControls();
        ArrayList<Control> voiceNonTriggersAfterTrigger = new ArrayList<Control>();
        ListIterator i = voiceControls.listIterator(voiceControls.indexOf(control) + 1);
        while (i.hasNext()) {
            Control subsequentVoiceControl = (Control)i.next();
            if (subsequentVoiceControl instanceof Trigger) continue;
            voiceNonTriggersAfterTrigger.add(subsequentVoiceControl);
        }
        List voicePages = voicePageWithTrigger.getDialog().getPages(DeviceType.VOICE);
        Page splitVoicePage = !voiceNonTriggersAfterTrigger.isEmpty() || voicePages.indexOf(voicePageWithTrigger) == voicePages.size() - 1 ? voicePageWithTrigger.split(voiceNonTriggersAfterTrigger) : null;
        return new Page[]{voicePageWithTrigger, splitVoicePage};
    }

    public static PageRegion getCorrespondingRegion(PageRegion region, Control control, DeviceType deviceType) {
        PageRegion correspondingRegion;
        deviceType.verifyTypeIsNotAll();
        PageRegion controlRegion = control == null ? null : control.getPageRegion(deviceType);
        if (controlRegion == null) {
            Page correspondingPage = region.getPage().getDialog().getLastPage(deviceType);
            correspondingRegion = deviceType == DeviceType.VOICE ? correspondingPage.getRegion(Direction.CENTER) : correspondingPage.getRegion(region.getName());
        } else {
            correspondingRegion = controlRegion;
        }
        return correspondingRegion;
    }

    private static void flattenClusterTree(Cluster cluster, List controls) {
        if (cluster == null) {
            return;
        }
        if (cluster.left == null && cluster.right == null) {
            controls.add(cluster.control);
        }
        DamaskUtils.flattenClusterTree(cluster.left, controls);
        DamaskUtils.flattenClusterTree(cluster.right, controls);
    }

    public static List getControlsInPositionOrder(PageRegion region, DeviceType controlDeviceType) {
        HashSet<Cluster> activeClusters = new HashSet<Cluster>();
        Iterator i = region.getControls().iterator();
        while (i.hasNext()) {
            Control control = (Control)i.next();
            if (controlDeviceType != null && !control.getDeviceType().equals(controlDeviceType) || control.getBoundsInParentCoords(region.getDeviceType()) == null) continue;
            activeClusters.add(new Cluster(control, region.getDeviceType()));
        }
        if (activeClusters.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        DamaskUtils.doHierarchicalClustering(activeClusters);
        ArrayList controls = new ArrayList();
        DamaskUtils.flattenClusterTree((Cluster)activeClusters.iterator().next(), controls);
        return controls;
    }

    public static Control getControlBefore(DeviceType pageDeviceType, Iterator controlsIterator, DeviceType newControlDeviceType, AffineTransform newControlTransform, Rectangle2D newControlBounds) {
        if (!controlsIterator.hasNext()) {
            return null;
        }
        HashSet<Cluster> activeClusters = new HashSet<Cluster>();
        while (controlsIterator.hasNext()) {
            Control control = (Control)controlsIterator.next();
            if (!control.getDeviceType().equals(newControlDeviceType)) continue;
            activeClusters.add(new Cluster(control, pageDeviceType));
        }
        activeClusters.add(new Cluster(GeomLib.transformRectangle(newControlTransform, newControlBounds)));
        DamaskUtils.doHierarchicalClustering(activeClusters);
        ArrayList controls = new ArrayList();
        DamaskUtils.flattenClusterTree((Cluster)activeClusters.iterator().next(), controls);
        int newControlIndex = controls.indexOf(null);
        if (newControlIndex == 0) {
            return null;
        }
        return (Control)controls.get(newControlIndex - 1);
    }

    private static void doHierarchicalClustering(Set activeClusters) {
        while (activeClusters.size() > 1) {
            double shortestDistance = Double.POSITIVE_INFINITY;
            double thetaForShortestDistance = Double.POSITIVE_INFINITY;
            Cluster nearestCluster1 = null;
            Cluster nearestCluster2 = null;
            Iterator i = activeClusters.iterator();
            while (i.hasNext()) {
                Cluster c1 = (Cluster)i.next();
                Iterator j = activeClusters.iterator();
                while (j.hasNext()) {
                    double y;
                    double x;
                    double r;
                    Cluster c2 = (Cluster)j.next();
                    if (c1 == c2 || !((r = Math.sqrt((x = c2.rect.getX() - c1.rect.getX()) * x + (y = c2.rect.getCenterY() - c1.rect.getCenterY()) * y)) < shortestDistance)) continue;
                    shortestDistance = r;
                    thetaForShortestDistance = Math.atan2(y, x);
                    nearestCluster1 = c1;
                    nearestCluster2 = c2;
                }
            }
            activeClusters.remove(nearestCluster1);
            activeClusters.remove(nearestCluster2);
            if (-1.1780972450961724 <= thetaForShortestDistance && thetaForShortestDistance <= 1.9634954084936207) {
                activeClusters.add(new Cluster(nearestCluster1, nearestCluster2));
                continue;
            }
            activeClusters.add(new Cluster(nearestCluster2, nearestCluster1));
        }
    }

    public static void addCommandsForAddingComponentToMacroCommand(MacroCommand cmd, Component newComponent, PageRegion region) {
        DamaskUtils.addCommandsForAddingComponentToMacroCommand(cmd, newComponent, region, null, true, true);
    }

    public static void addCommandsForAddingComponentToMacroCommand(MacroCommand cmd, Component newComponent, PageRegion region, ComponentGroup group, boolean autoFindGroup, boolean autoCreateVoiceContent) {
        NewComponentInfo newComponentInfo = DamaskUtils.inferBoundsAndTransform(newComponent, region, group, autoFindGroup);
        Component actualNewComponent = newComponentInfo.getNewComponent();
        Content newContentAboveNewComponent = newComponentInfo.getNewContentAboveNewComponent();
        Trigger newTriggerBelowNewComponent = newComponentInfo.getNewTriggerBelowNewComponent();
        Trigger placeholderToRemove = newComponentInfo.getPlaceholderToRemove();
        Control controlBefore = newComponentInfo.getControlBefore();
        ComponentGroup groupForNewComponents = newComponentInfo.getComponentGroup();
        if (actualNewComponent.isVisibleToDeviceType(DeviceType.VOICE)) {
            PageRegion voiceRegion = controlBefore == null ? region.getPage().getDialog().getPageRegionToAddTo(region, true, DeviceType.VOICE) : region.getPage().getDialog().getPageRegionToAddTo(controlBefore, DeviceType.VOICE);
            if (newContentAboveNewComponent != null && autoCreateVoiceContent) {
                DamaskUtils.addCommandsForAddingOneComponentToMacroCommand(cmd, voiceRegion, newComponentInfo, newContentAboveNewComponent, controlBefore instanceof Select.Item ? ((Select.Item)controlBefore).getParent() : controlBefore, groupForNewComponents);
                controlBefore = newContentAboveNewComponent;
            }
            if (placeholderToRemove != null) {
                cmd.addCommand(new RemoveControlCommand(placeholderToRemove));
            }
        }
        DamaskUtils.addCommandsForAddingOneComponentToMacroCommand(cmd, region, newComponentInfo, actualNewComponent, controlBefore, groupForNewComponents);
        if (actualNewComponent.isVisibleToDeviceType(DeviceType.VOICE) && newTriggerBelowNewComponent != null) {
            cmd.addCommand(new AddControlCommand((Control)actualNewComponent, (Control)newTriggerBelowNewComponent));
        }
    }

    private static void addCommandsForAddingOneComponentToMacroCommand(MacroCommand cmd, PageRegion region, NewComponentInfo newComponentInfo, Component actualNewComponent, Control controlBefore, ComponentGroup groupForNewComponents) {
        if (actualNewComponent instanceof Select.Item) {
            Select selectToAddTo = newComponentInfo.getSelectToAddTo();
            cmd.addCommand(new AddItemCommand(selectToAddTo, selectToAddTo.getItems().indexOf(controlBefore) + 1, (Select.Item)actualNewComponent));
        } else if (actualNewComponent instanceof Control) {
            if (controlBefore == null) {
                cmd.addCommand(new AddControlCommand(region, (Control)actualNewComponent));
                if (actualNewComponent.isVisibleToDeviceType(DeviceType.VOICE)) {
                    ArrayList<Component> newPageComponents = new ArrayList<Component>();
                    newPageComponents.add(actualNewComponent);
                    PageRegion voiceRegion = region.getPage().getDialog().getPageRegionToAddTo(region, true, DeviceType.VOICE);
                    if (DamaskUtils.shouldSplitVoiceRegion(voiceRegion, actualNewComponent)) {
                        cmd.addCommand(new SplitPageCommand(voiceRegion.getPage(), newPageComponents, 0.0));
                    }
                }
            } else {
                cmd.addCommand(new AddControlCommand(controlBefore, (Control)actualNewComponent));
                cmd.addCommand(new ChangePageRegionCommand((Control)actualNewComponent, region.getDeviceType(), region));
                if (actualNewComponent.isVisibleToDeviceType(DeviceType.VOICE)) {
                    ArrayList<Component> newPageComponents = new ArrayList<Component>();
                    newPageComponents.add(actualNewComponent);
                    PageRegion voiceRegion = controlBefore.getDialog().getPageRegionToAddTo(controlBefore, DeviceType.VOICE);
                    if (DamaskUtils.shouldSplitVoiceRegion(voiceRegion, actualNewComponent)) {
                        cmd.addCommand(new SplitPageCommand(voiceRegion.getPage(), newPageComponents, 0.0));
                    }
                }
            }
        } else {
            cmd.addCommand(new AddGroupCommand(region.getPage().getDialog(), (ComponentGroup)actualNewComponent));
        }
        if (groupForNewComponents != null) {
            cmd.addCommand(new AddComponentToGroupCommand(groupForNewComponents, actualNewComponent));
        }
    }

    private static boolean shouldSplitVoiceRegion(PageRegion voiceRegion, Component newComponent) {
        boolean shouldSplit;
        block3: {
            block5: {
                block4: {
                    shouldSplit = false;
                    if (!(newComponent instanceof SelectMany)) break block4;
                    shouldSplit = false;
                    Iterator i = voiceRegion.getControls().iterator();
                    while (i.hasNext()) {
                        Control voiceControl = (Control)i.next();
                        if (voiceControl instanceof Trigger) continue;
                        shouldSplit = true;
                        break block3;
                    }
                    break block3;
                }
                if (!(newComponent instanceof Content)) break block5;
                shouldSplit = false;
                Iterator i = voiceRegion.getControls().iterator();
                while (i.hasNext()) {
                    Control voiceControl = (Control)i.next();
                    if (!(voiceControl instanceof Content) && !(voiceControl instanceof SelectMany)) continue;
                    shouldSplit = true;
                    break block3;
                }
                break block3;
            }
            if (!(newComponent instanceof SelectOne) && !(newComponent instanceof TextInput)) break block3;
            shouldSplit = false;
            Iterator i = voiceRegion.getControls().iterator();
            while (i.hasNext()) {
                Control voiceControl = (Control)i.next();
                if (voiceControl instanceof Content || voiceControl instanceof Trigger) continue;
                shouldSplit = true;
                break;
            }
        }
        return shouldSplit;
    }

    public static void addCommandsForRemovingControlToMacroCommand(MacroCommand cmd, Control control) {
        if (control instanceof Select.Item) {
            Select.Item selectItem = (Select.Item)control;
            Select select = selectItem.getParent();
            cmd.addCommand(new RemoveItemCommand(select, selectItem));
            if (select.getItems().size() == 1) {
                cmd.addCommand(new RemoveControlCommand(select));
            }
        } else {
            cmd.addCommand(new RemoveControlCommand(control));
        }
    }

    private static NewComponentInfo inferBoundsAndTransform(Component component, PageRegion region, ComponentGroup group, boolean autoFindGroup) {
        DeviceType deviceType = component.getDeviceType();
        DeviceType regionDeviceType = region.getDeviceType();
        AffineTransform transform = DamaskUtils.getTransform(component, region);
        Rectangle2D bounds = DamaskUtils.getBounds(component, region);
        if (autoFindGroup) {
            group = DamaskUtils.getDeepestGroupAt(region, transform, bounds, deviceType == DeviceType.ALL);
        }
        Component newComponent = component;
        Control controlBefore = null;
        Select selectToAddTo = null;
        if (component instanceof Select.Item) {
            Class<?> selectClass;
            Select.Item item = (Select.Item)component;
            if (item instanceof SelectOne.Item) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("edu.berkeley.guir.damask.component.SelectOne");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                selectClass = clazz;
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("edu.berkeley.guir.damask.component.SelectMany");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                selectClass = clazz;
            }
            selectToAddTo = DamaskUtils.findExistingSelect(region, group, item.getDeviceType(), selectClass, Select.FULL);
            if (selectToAddTo != null) {
                Iterator i = deviceType.getSpecificDeviceTypes().iterator();
                while (i.hasNext()) {
                    DeviceType aDeviceType = (DeviceType)i.next();
                    if (aDeviceType == regionDeviceType) continue;
                    item.setContentInsets(aDeviceType, item.getDefaultInsets(aDeviceType, selectToAddTo.getStyle(aDeviceType)));
                }
                controlBefore = selectToAddTo.getItemBefore(regionDeviceType, item.getDeviceType(), item.getTransform(regionDeviceType), item.getBounds(regionDeviceType));
                group = null;
            } else {
                newComponent = item instanceof SelectOne.Item ? new SelectOne(deviceType) : new SelectMany(deviceType);
                Select newSelect = (Select)newComponent;
                Iterator i = deviceType.getSpecificDeviceTypes().iterator();
                while (i.hasNext()) {
                    DeviceType aDeviceType = (DeviceType)i.next();
                    if (aDeviceType == regionDeviceType) continue;
                    item.setContentInsets(aDeviceType, item.getDefaultInsets(aDeviceType, newSelect.getStyle(aDeviceType)));
                }
                newSelect.addItem(item);
            }
        }
        if (controlBefore == null && selectToAddTo == null && bounds != null) {
            controlBefore = group != null ? DamaskUtils.getControlBefore(regionDeviceType, group.getChildren(regionDeviceType).iterator(), deviceType, transform, bounds) : region.getPage().getDialog().getControlBefore(region, deviceType, transform, bounds);
        }
        boolean putVoiceTriggerBelowNewControl = false;
        boolean putVoiceContentAboveNewControl = false;
        Content newVoiceContent = null;
        Object controlAfter = null;
        Trigger placeholderToRemove = null;
        if (newComponent instanceof Control && newComponent.isVisibleToDeviceType(DeviceType.VOICE)) {
            PageRegion voiceRegion = DamaskUtils.getCorrespondingRegion(region, controlBefore, DeviceType.VOICE);
            Control voiceControlAfter = null;
            if (!voiceRegion.getControls().isEmpty() && !DamaskUtils.shouldSplitVoiceRegion(voiceRegion, newComponent) && (voiceControlAfter = controlBefore == null ? (Control)voiceRegion.getControls().get(0) : DamaskUtils.getNextLowLevelControl(voiceRegion, controlBefore)) instanceof Trigger && newComponent instanceof Trigger) {
                placeholderToRemove = (Trigger)voiceControlAfter;
            }
            putVoiceTriggerBelowNewControl = !(newComponent instanceof Content) && !(newComponent instanceof Trigger) && !(voiceControlAfter instanceof Trigger);
        }
        Content newContentAboveNewControl = null;
        Trigger newTriggerBelowNewControl = null;
        newVoiceContent = new Content(DeviceType.VOICE, "Text");
        if (putVoiceTriggerBelowNewControl) {
            newTriggerBelowNewControl = new Trigger(DeviceType.VOICE, newVoiceContent);
        }
        if (putVoiceContentAboveNewControl) {
            newContentAboveNewControl = newVoiceContent;
        }
        return new NewComponentInfo(newComponent, newContentAboveNewControl, newTriggerBelowNewControl, placeholderToRemove, selectToAddTo, controlBefore, group);
    }

    private static Rectangle2D getBounds(Component component, PageRegion region) {
        DeviceType deviceType = region.getDeviceType();
        if (component instanceof Control) {
            return ((Control)component).getBounds(deviceType);
        }
        return ((ComponentGroup)component).getBoundsInPageRegion(region);
    }

    private static AffineTransform getTransform(Component component, PageRegion region) {
        DeviceType deviceType = region.getDeviceType();
        if (component instanceof Control) {
            return ((Control)component).getTransform(deviceType);
        }
        return ((ComponentGroup)component).getTransformInPageRegion(region);
    }

    private static void addCommandsForMovingOverlappingComponentsToMacroCommand(MacroCommand cmd, PageRegion region, Rectangle2D newControlBounds, double dx, double dy) {
        DeviceType deviceType = region.getDeviceType();
        List controls = region.getControls();
        Iterator i = controls.iterator();
        while (i.hasNext()) {
            Control control = (Control)i.next();
            Rectangle2D controlBounds = control.getBoundsInParentCoords(deviceType);
            boolean shouldMove = false;
            if (dx < 0.0) {
                shouldMove |= controlBounds.getX() <= newControlBounds.getX();
            } else if (dx > 0.0) {
                shouldMove |= controlBounds.getX() >= newControlBounds.getX();
            }
            if (dy < 0.0) {
                shouldMove |= controlBounds.getY() <= newControlBounds.getY();
            } else if (dy > 0.0) {
                shouldMove |= controlBounds.getY() >= newControlBounds.getY();
            }
            if (!shouldMove) continue;
            if (control instanceof Select && ((Select)control).getStyle(deviceType) == Select.FULL) {
                Iterator j = ((Select)control).getItems().iterator();
                while (j.hasNext()) {
                    Select.Item item = (Select.Item)j.next();
                    AffineTransform transform = item.getTransform(deviceType);
                    transform.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
                    cmd.addCommand(new SetTransformCommand(item, deviceType, transform));
                }
                continue;
            }
            AffineTransform transform = control.getTransform(deviceType);
            transform.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
            cmd.addCommand(new SetTransformCommand(control, deviceType, transform));
        }
    }

    public static Control getPreviousLowLevelControl(PageRegion region, Control control) {
        if (control instanceof Select.Item) {
            Select.Item item = (Select.Item)control;
            Select select = item.getParent();
            int index = select.getItems().indexOf(item);
            if (index > 0 && select.getStyle(region.getDeviceType()) == Select.FULL) {
                return (Select.Item)select.getItems().get(index - 1);
            }
            return DamaskUtils.getPreviousLowLevelControl(region, item.getParent());
        }
        Control controlBefore = region.getPreviousControl(control);
        if (controlBefore instanceof Select && ((Select)controlBefore).getStyle(region.getDeviceType()) == Select.FULL) {
            List items = ((Select)controlBefore).getItems();
            if (items.isEmpty()) {
                return DamaskUtils.getPreviousLowLevelControl(region, controlBefore);
            }
            return (Select.Item)items.get(items.size() - 1);
        }
        return controlBefore;
    }

    public static Control getNextLowLevelControl(PageRegion region, Control control) {
        if (control instanceof Select.Item) {
            Select.Item item = (Select.Item)control;
            Select select = item.getParent();
            List items = select.getItems();
            int index = items.indexOf(item);
            if (index < items.size() - 1 && select.getStyle(region.getDeviceType()) == Select.FULL) {
                return (Select.Item)select.getItems().get(index + 1);
            }
            return DamaskUtils.getNextLowLevelControl(region, item.getParent());
        }
        Control controlAfter = region.getNextControl(control);
        if (controlAfter instanceof Select && ((Select)controlAfter).getStyle(region.getDeviceType()) == Select.FULL) {
            List items = ((Select)controlAfter).getItems();
            if (items.size() == 0) {
                return controlAfter;
            }
            return (Select.Item)items.get(items.size() - 1);
        }
        return controlAfter;
    }

    public static Control getPreviousControlWithPrompt(PageRegion region, Control control) {
        Control prevControl = DamaskUtils.getPreviousLowLevelControl(region, control);
        Rectangle2D prevPromptBounds = prevControl == null ? null : prevControl.getVoicePromptBounds();
        while (prevPromptBounds == null && prevControl != null) {
            Rectangle2D rectangle2D = prevPromptBounds = (prevControl = DamaskUtils.getPreviousLowLevelControl(region, prevControl)) == null ? null : prevControl.getVoicePromptBounds();
        }
        return prevControl;
    }

    public static Control getNextControlWithPrompt(PageRegion region, Control control) {
        Control nextControl = DamaskUtils.getNextLowLevelControl(region, control);
        Rectangle2D nextPromptBounds = nextControl == null ? null : nextControl.getVoicePromptBounds();
        while (nextPromptBounds == null && nextControl != null) {
            Rectangle2D rectangle2D = nextPromptBounds = (nextControl = DamaskUtils.getNextLowLevelControl(region, nextControl)) == null ? null : nextControl.getVoicePromptBounds();
        }
        return nextControl;
    }

    public static String toShortString(Object o) {
        if (o == null) {
            return "null";
        }
        String s = String.valueOf(o.getClass().getName()) + "@" + Integer.toHexString(o.hashCode());
        return s.replaceAll(".*\\.", "");
    }

    private static class Cluster {
        public final Rectangle2D rect;
        public final Cluster left;
        public final Cluster right;
        public final Control control;

        public Cluster(Cluster left, Cluster right) {
            this.left = left;
            this.right = right;
            this.rect = left.rect.createUnion(right.rect);
            this.control = null;
        }

        public Cluster(Control control, DeviceType deviceType) {
            this.control = control;
            this.rect = control.getBoundsInParentCoords(deviceType);
            this.left = null;
            this.right = null;
        }

        public Cluster(Rectangle2D rect) {
            this.rect = rect;
            this.control = null;
            this.left = null;
            this.right = null;
        }

        public String toString() {
            if (this.control != null) {
                return "[" + this.control + "]";
            }
            if (this.left == null && this.right == null) {
                return "[X]";
            }
            String leftStr = this.left == null ? "" : this.left.toString();
            String rightStr = this.right == null ? "" : this.right.toString();
            return "[" + leftStr + ", " + rightStr + "]";
        }
    }

    private static class NewComponentInfo {
        private final Content newContentAboveNewComponent;
        private final Component newComponent;
        private final Trigger newTriggerBelowNewComponent;
        private final Trigger placeholderToRemove;
        private final Select select;
        private final Control controlBefore;
        private final ComponentGroup group;

        public NewComponentInfo(Component newComponent, Content newContentAboveNewComponent, Trigger newTriggerBelowNewComponent, Trigger placeholderToRemove, Select selectToAddTo, Control controlBefore, ComponentGroup group) {
            this.newComponent = newComponent;
            this.newContentAboveNewComponent = newContentAboveNewComponent;
            this.newTriggerBelowNewComponent = newTriggerBelowNewComponent;
            this.placeholderToRemove = placeholderToRemove;
            this.select = selectToAddTo;
            this.controlBefore = controlBefore;
            this.group = group;
        }

        public Component getNewComponent() {
            return this.newComponent;
        }

        public Content getNewContentAboveNewComponent() {
            return this.newContentAboveNewComponent;
        }

        public Trigger getNewTriggerBelowNewComponent() {
            return this.newTriggerBelowNewComponent;
        }

        public Trigger getPlaceholderToRemove() {
            return this.placeholderToRemove;
        }

        public Control getControlBefore() {
            return this.controlBefore;
        }

        public Select getSelectToAddTo() {
            return this.select;
        }

        public ComponentGroup getComponentGroup() {
            return this.group;
        }
    }
}

