/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.event.ConnectionEvent;
import edu.berkeley.guir.damask.event.ConnectionListener;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.damask.pattern.PatternInstanceMember;
import edu.berkeley.guir.lib.collection.Map2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DamaskStateTree
extends JTree {
    private static final String ROOT = "Damask";
    private static final String DIALOGS = "Dialogs";
    private static final String CONNECTIONS = "Connections";
    private static final String PATTERN_INSTANCES = "Pattern Instances";
    private static final String COMPONENT_GROUPS = "Component Groups";
    private final Map2D nodes = new Map2D();
    private final DefaultMutableTreeNode root = new DefaultMutableTreeNode("Damask");
    private final DefaultTreeModel model;
    private final InteractionGraphListener interactionGraphListener = new InteractionGraphListener();
    private final DialogListener dialogListener = new DialogListener();
    private final PageListener pageListener = new PageListener();
    private final PageRegionListener pageRegionListener = new PageRegionListener();
    private final ControlListener controlListener = new ControlListener();
    private final ConnectionEventListener connectionListener = new ConnectionEventListener();
    private final PatternInstanceListener patternInstanceListener = new PatternInstanceListener();
    private final SelectListener selectListener = new SelectListener();
    private final ComponentGroupListener componentGroupListener = new ComponentGroupListener();

    public DamaskStateTree(InteractionGraph graph) {
        this.setShowsRootHandles(true);
        graph.addElementContainerListener(this.interactionGraphListener);
        this.model = new StateTreeModel(this.root);
        this.setModel(this.model);
        Iterator i = Damask.getSupportedDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(deviceType);
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(DIALOGS);
            deviceNode.add(treeNode);
            this.nodes.put(deviceType, DIALOGS, treeNode);
            treeNode = new DefaultMutableTreeNode(CONNECTIONS);
            deviceNode.add(treeNode);
            this.nodes.put(deviceType, CONNECTIONS, treeNode);
            treeNode = new DefaultMutableTreeNode(PATTERN_INSTANCES);
            deviceNode.add(treeNode);
            this.nodes.put(deviceType, PATTERN_INSTANCES, treeNode);
            treeNode = new DefaultMutableTreeNode(COMPONENT_GROUPS);
            deviceNode.add(treeNode);
            this.nodes.put(deviceType, COMPONENT_GROUPS, treeNode);
            this.root.add(deviceNode);
        }
        this.setRootVisible(false);
        this.expandPath(new TreePath(this.root));
    }

    private int getAddPosition(Collection collection, TreeNode parent, Object object) {
        if (collection instanceof List) {
            return ((List)collection).indexOf(object);
        }
        return parent.getChildCount();
    }

    private MutableTreeNode addElementToTree(DeviceType deviceType, MutableTreeNode parent, int position, InteractionElement element) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(element);
        this.nodes.put(deviceType, element, child);
        this.model.insertNodeInto(child, parent, position);
        return child;
    }

    private void addPageToTree(DeviceType deviceType, MutableTreeNode dialogNode, int position, Page p) {
        MutableTreeNode pageNode = this.addElementToTree(deviceType, dialogNode, position, p);
        p.addInteractionElementListener(this.pageListener);
        Iterator i = p.getRegions().iterator();
        while (i.hasNext()) {
            PageRegion region = (PageRegion)i.next();
            if (!region.getControls().isEmpty()) {
                MutableTreeNode regionNode = this.addElementToTree(deviceType, pageNode, pageNode.getChildCount(), region);
                Iterator j = region.getControls().iterator();
                while (j.hasNext()) {
                    Control control = (Control)j.next();
                    this.addElementToTree(deviceType, regionNode, regionNode.getChildCount(), control);
                    control.addInteractionElementListener(this.controlListener);
                }
            }
            region.addElementContainerListener(this.pageRegionListener);
            region.addInteractionElementListener(this.pageRegionListener);
        }
    }

    private MutableTreeNode removeElementFromTree(DeviceType deviceType, InteractionElement element) {
        MutableTreeNode child = (MutableTreeNode)this.nodes.get(deviceType, element);
        this.nodes.put(deviceType, element, null);
        if (child != null) {
            this.model.removeNodeFromParent(child);
        }
        return child;
    }

    private void removePageFromTree(DeviceType deviceType, Page p) {
        Iterator i = p.getRegions().iterator();
        while (i.hasNext()) {
            PageRegion region = (PageRegion)i.next();
            this.removeElementFromTree(deviceType, region);
            region.removeElementContainerListener(this.pageRegionListener);
            region.removeInteractionElementListener(this.pageRegionListener);
        }
        this.removeElementFromTree(deviceType, p);
        p.removeInteractionElementListener(this.pageListener);
    }

    private final class InteractionGraphListener
    implements ElementContainerListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.DamaskStateTree$InteractionGraphListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        InteractionGraphListener() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Object container = e.getSource();
            InteractionElement element = e.getElement();
            if (!(container instanceof InteractionGraph)) {
                return;
            }
            InteractionGraph g = (InteractionGraph)container;
            Iterator i = Damask.getSupportedDeviceTypes().iterator();
            while (i.hasNext()) {
                int position;
                MutableTreeNode parent;
                DeviceType aDeviceType = (DeviceType)i.next();
                if (element instanceof Dialog) {
                    Dialog d = (Dialog)element;
                    parent = (MutableTreeNode)DamaskStateTree.this.nodes.get(aDeviceType, DamaskStateTree.DIALOGS);
                    position = DamaskStateTree.this.getAddPosition(g.getDialogs(), parent, element);
                    if (!d.isEnabled(aDeviceType)) continue;
                    MutableTreeNode child = DamaskStateTree.this.addElementToTree(aDeviceType, parent, position, d);
                    d.addElementContainerListener(DamaskStateTree.this.dialogListener);
                    d.addInteractionElementListener(DamaskStateTree.this.dialogListener);
                    Iterator j = d.getPages(aDeviceType).iterator();
                    while (j.hasNext()) {
                        Page p = (Page)j.next();
                        DamaskStateTree.this.addPageToTree(aDeviceType, child, child.getChildCount(), p);
                    }
                    continue;
                }
                if (element instanceof Connection) {
                    Connection c = (Connection)element;
                    parent = (MutableTreeNode)DamaskStateTree.this.nodes.get(aDeviceType, DamaskStateTree.CONNECTIONS);
                    position = DamaskStateTree.this.getAddPosition(g.getConnections(), parent, element);
                    if (!c.isVisibleToDeviceType(aDeviceType)) continue;
                    DamaskStateTree.this.addElementToTree(aDeviceType, parent, position, c);
                    c.addConnectionListener(DamaskStateTree.this.connectionListener);
                    c.addInteractionElementListener(DamaskStateTree.this.connectionListener);
                    continue;
                }
                if (element instanceof PatternInstance) {
                    PatternInstance pi = (PatternInstance)element;
                    parent = (MutableTreeNode)DamaskStateTree.this.nodes.get(aDeviceType, DamaskStateTree.PATTERN_INSTANCES);
                    position = DamaskStateTree.this.getAddPosition(g.getPatternInstances(), parent, element);
                    DamaskStateTree.this.addElementToTree(aDeviceType, parent, position, pi);
                    pi.addInteractionElementListener(DamaskStateTree.this.patternInstanceListener);
                    pi.addElementContainerListener(DamaskStateTree.this.patternInstanceListener);
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"element added to graph must be dialog, connection, or pattern instance");
                }
            }
        }

        public void elementRemoved(ElementContainerEvent e) {
            Object container = e.getSource();
            InteractionElement element = e.getElement();
            if (!(container instanceof InteractionGraph)) {
                return;
            }
            Iterator i = Damask.getSupportedDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                if (element instanceof Dialog) {
                    Dialog d = (Dialog)element;
                    Iterator j = d.getPages(aDeviceType).iterator();
                    while (j.hasNext()) {
                        Page p = (Page)j.next();
                        DamaskStateTree.this.removePageFromTree(aDeviceType, p);
                    }
                    d.removeElementContainerListener(DamaskStateTree.this.dialogListener);
                    d.removeInteractionElementListener(DamaskStateTree.this.dialogListener);
                    DamaskStateTree.this.removeElementFromTree(aDeviceType, d);
                    continue;
                }
                if (element instanceof Connection) {
                    Connection c = (Connection)element;
                    DamaskStateTree.this.removeElementFromTree(aDeviceType, c);
                    c.removeConnectionListener(DamaskStateTree.this.connectionListener);
                    c.removeInteractionElementListener(DamaskStateTree.this.connectionListener);
                    continue;
                }
                if (element instanceof PatternInstance) {
                    PatternInstance pi = (PatternInstance)element;
                    DamaskStateTree.this.removeElementFromTree(aDeviceType, pi);
                    pi.removeInteractionElementListener(DamaskStateTree.this.patternInstanceListener);
                    pi.removeElementContainerListener(DamaskStateTree.this.patternInstanceListener);
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"element added to graph must be dialog, connection, or pattern instance");
                }
            }
        }
    }

    private final class DialogListener
    implements ElementContainerListener,
    InteractionElementListener {
        DialogListener() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Object container = e.getSource();
            DeviceType deviceType = e.getDeviceType();
            if (!(container instanceof Dialog)) {
                return;
            }
            Dialog dialog = (Dialog)container;
            if (e.getElement() instanceof Page) {
                Page page = (Page)e.getElement();
                MutableTreeNode parent = (MutableTreeNode)DamaskStateTree.this.nodes.get(deviceType, dialog);
                int position = DamaskStateTree.this.getAddPosition(dialog.getPages(deviceType), parent, page);
                DamaskStateTree.this.addPageToTree(deviceType, parent, position, page);
            }
        }

        public void elementRemoved(ElementContainerEvent e) {
            Object container = e.getSource();
            DeviceType deviceType = e.getDeviceType();
            if (!(container instanceof Dialog)) {
                return;
            }
            if (e.getElement() instanceof Page) {
                Page page = (Page)e.getElement();
                DamaskStateTree.this.removePageFromTree(deviceType, page);
            }
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private final class PageListener
    implements InteractionElementListener {
        PageListener() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private final class PageRegionListener
    implements ElementContainerListener,
    InteractionElementListener {
        PageRegionListener() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Object container = e.getSource();
            DeviceType deviceType = e.getDeviceType();
            if (!(container instanceof PageRegion)) {
                return;
            }
            PageRegion region = (PageRegion)container;
            Control control = (Control)e.getElement();
            MutableTreeNode parent = (MutableTreeNode)DamaskStateTree.this.nodes.get(deviceType, region);
            if (parent == null) {
                MutableTreeNode pageNode = (MutableTreeNode)DamaskStateTree.this.nodes.get(deviceType, region.getPage());
                List regionNames = Direction.getValues();
                int regionNameIndex = regionNames.indexOf(region.getName());
                int regionNodeIndex = pageNode.getChildCount();
                int i = 0;
                int n = pageNode.getChildCount();
                while (i < n) {
                    PageRegion aRegion = (PageRegion)((DefaultMutableTreeNode)pageNode.getChildAt(i)).getUserObject();
                    int aNameIndex = regionNames.indexOf(aRegion.getName());
                    if (aNameIndex > regionNameIndex) {
                        regionNodeIndex = i;
                    }
                    ++i;
                }
                parent = DamaskStateTree.this.addElementToTree(deviceType, pageNode, regionNodeIndex, region);
            }
            int position = DamaskStateTree.this.getAddPosition(region.getControls(), parent, control);
            MutableTreeNode controlTreeNode = DamaskStateTree.this.addElementToTree(deviceType, parent, position, control);
            if (control instanceof Select) {
                Select select = (Select)control;
                select.addElementContainerListener(DamaskStateTree.this.selectListener);
                Iterator i = select.getItems().iterator();
                while (i.hasNext()) {
                    Select.Item item = (Select.Item)i.next();
                    DamaskStateTree.this.addElementToTree(deviceType, controlTreeNode, controlTreeNode.getChildCount(), item);
                }
            }
            control.addInteractionElementListener(DamaskStateTree.this.controlListener);
        }

        public void elementRemoved(ElementContainerEvent e) {
            Object container = e.getSource();
            DeviceType deviceType = e.getDeviceType();
            if (!(container instanceof PageRegion)) {
                return;
            }
            Control control = (Control)e.getElement();
            control.removeInteractionElementListener(DamaskStateTree.this.controlListener);
            DamaskStateTree.this.removeElementFromTree(deviceType, control);
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private final class ControlListener
    implements InteractionElementListener {
        ControlListener() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private final class ConnectionEventListener
    implements InteractionElementListener,
    ConnectionListener {
        ConnectionEventListener() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }

        public void sourceChanged(ConnectionEvent e) {
        }

        public void destChanged(ConnectionEvent e) {
        }

        public void shapeChanged(ConnectionEvent e) {
        }

        public void userEventChanged(ConnectionEvent e) {
        }

        public void conditionChanged(ConnectionEvent e) {
        }
    }

    private final class PatternInstanceListener
    implements ElementContainerListener,
    InteractionElementListener {
        PatternInstanceListener() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Object container = e.getSource();
            DeviceType deviceType = e.getDeviceType();
            if (!(container instanceof PatternInstance)) {
                return;
            }
            PatternInstance pi = (PatternInstance)container;
            PatternInstanceMember element = (PatternInstanceMember)e.getElement();
            MutableTreeNode parent = (MutableTreeNode)DamaskStateTree.this.nodes.get(deviceType, container);
            int position = DamaskStateTree.this.getAddPosition(pi.getMembers(), parent, element);
            DamaskStateTree.this.addElementToTree(deviceType, parent, position, element);
        }

        public void elementRemoved(ElementContainerEvent e) {
            Object container = e.getSource();
            DeviceType deviceType = e.getDeviceType();
            if (!(container instanceof PatternInstance)) {
                return;
            }
            PatternInstanceMember element = (PatternInstanceMember)e.getElement();
            DamaskStateTree.this.removeElementFromTree(deviceType, element);
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private final class SelectListener
    implements ElementContainerListener {
        SelectListener() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Object container = e.getSource();
            DeviceType deviceType = e.getDeviceType();
            if (!(container instanceof Select)) {
                return;
            }
            Select select = (Select)container;
            Select.Item element = (Select.Item)e.getElement();
            Iterator i = deviceType.getSpecificDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                MutableTreeNode parent = (MutableTreeNode)DamaskStateTree.this.nodes.get(aDeviceType, select);
                if (parent == null) continue;
                int position = DamaskStateTree.this.getAddPosition(select.getItems(), parent, element);
                DamaskStateTree.this.addElementToTree(aDeviceType, parent, position, element);
            }
        }

        public void elementRemoved(ElementContainerEvent e) {
            Object container = e.getSource();
            DeviceType deviceType = e.getDeviceType();
            if (!(container instanceof Select)) {
                return;
            }
            Select.Item element = (Select.Item)e.getElement();
            DamaskStateTree.this.removeElementFromTree(deviceType, element);
        }
    }

    private final class ComponentGroupListener
    implements ElementContainerListener {
        ComponentGroupListener() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Object container = e.getSource();
            DeviceType deviceType = e.getDeviceType();
            InteractionElement element = e.getElement();
            if (!(container instanceof ComponentGroup)) {
                return;
            }
            ComponentGroup g = (ComponentGroup)container;
            MutableTreeNode parent = (MutableTreeNode)DamaskStateTree.this.nodes.get(deviceType, g);
            if (parent == null) {
                parent = new DefaultMutableTreeNode(element.toString());
                DamaskStateTree.this.nodes.put(deviceType, g, parent);
                MutableTreeNode groupNode = (MutableTreeNode)DamaskStateTree.this.nodes.get(deviceType, DamaskStateTree.COMPONENT_GROUPS);
                groupNode.insert(parent, groupNode.getChildCount());
            }
            int position = DamaskStateTree.this.getAddPosition(g.getChildren(deviceType), parent, element);
            DamaskStateTree.this.addElementToTree(deviceType, parent, position, element);
        }

        public void elementRemoved(ElementContainerEvent e) {
            Object container = e.getSource();
            DeviceType deviceType = e.getDeviceType();
            InteractionElement element = e.getElement();
            if (!(container instanceof ComponentGroup)) {
                return;
            }
            DamaskStateTree.this.removeElementFromTree(deviceType, element);
        }
    }

    private final class StateTreeModel
    extends DefaultTreeModel {
        public StateTreeModel(TreeNode root) {
            super(root);
        }
    }
}

