/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.event.InteractionElementSource;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.id.GUID;
import edu.berkeley.guir.lib.util.ClassLib;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractInteractionElement
implements InteractionElement {
    private GUID id;
    private WeakReference cloneSource = null;
    private WeakReference lastClone = null;
    private Map bounds = new HashMap();
    private Map transforms = new HashMap();
    private InteractionElementSource elementEventSource = new InteractionElementSource();

    public AbstractInteractionElement() {
        this.id = new GUID();
    }

    public AbstractInteractionElement(AbstractInteractionElement element) {
        this();
        this.bounds = new HashMap(element.bounds);
        this.transforms = new HashMap(element.transforms);
    }

    public GUID getId() {
        return this.id;
    }

    public InteractionElement getCloneSourceIfAlive() {
        if (this.cloneSource != null) {
            return (InteractionElement)this.cloneSource.get();
        }
        return null;
    }

    public InteractionElement getMostRecentCloneIfAlive() {
        if (this.lastClone != null) {
            return (InteractionElement)this.lastClone.get();
        }
        return null;
    }

    public abstract InteractionGraph getInteractionGraph();

    public Set getDeviceTypesVisibleTo() {
        return new HashSet(this.bounds.keySet());
    }

    public boolean isVisibleToDeviceType(DeviceType deviceType) {
        if (deviceType == DeviceType.ALL) {
            Set visibleDeviceTypes = this.getDeviceTypesVisibleTo();
            HashSet allDeviceTypes = new HashSet(DeviceType.ALL.getSpecificDeviceTypes());
            Iterator i = visibleDeviceTypes.iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                allDeviceTypes.remove(aDeviceType);
            }
            return allDeviceTypes.isEmpty();
        }
        return this.getDeviceTypesVisibleTo().contains(deviceType);
    }

    public Rectangle2D getBounds(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        Rectangle2D result = (Rectangle2D)this.bounds.get(deviceType);
        if (result == null) {
            return null;
        }
        return (Rectangle2D)result.clone();
    }

    public Rectangle2D getBoundsInParentCoords(DeviceType deviceType) {
        Rectangle2D bounds = this.getBounds(deviceType);
        if (bounds == null) {
            return null;
        }
        AffineTransform transform = this.getTransform(deviceType);
        return GeomLib.transformRectangle(transform, bounds);
    }

    public void setBounds(DeviceType deviceType, Rectangle2D newBounds) {
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(deviceType), this + " supports " + this.getDeviceTypesVisibleTo() + ", not " + deviceType);
        Rectangle2D newBoundsClone = newBounds == null ? null : (Rectangle2D)newBounds.clone();
        Iterator i = deviceType.getSpecificDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.bounds.put(aDeviceType, newBoundsClone);
            this.fireElementBoundsUpdated(aDeviceType);
        }
    }

    public Point2D getLocation(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        Rectangle2D bounds = this.getBounds(deviceType);
        return new Point2D.Double(bounds.getX(), bounds.getY());
    }

    public void setLocation(DeviceType deviceType, Point2D newLocation) {
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(deviceType), this + " supports " + this.getDeviceTypesVisibleTo() + ", not " + deviceType);
        Collection c = deviceType.getSpecificDeviceTypes();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            Rectangle2D newBounds = this.getBounds(aDeviceType);
            newBounds.setRect(newLocation.getX(), newLocation.getY(), newBounds.getWidth(), newBounds.getHeight());
            this.bounds.put(aDeviceType, newBounds);
            this.fireElementBoundsUpdated(aDeviceType);
        }
    }

    public AffineTransform getTransform(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        AffineTransform result = (AffineTransform)this.transforms.get(deviceType);
        if (result == null) {
            return new AffineTransform();
        }
        return (AffineTransform)result.clone();
    }

    public void setTransform(DeviceType deviceType, AffineTransform newTransform) {
        DamaskUtils.checkValidArgument(this.isVisibleToDeviceType(deviceType), this + " supports " + this.getDeviceTypesVisibleTo() + ", not " + deviceType);
        AffineTransform newTransformClone = newTransform == null ? null : (AffineTransform)newTransform.clone();
        Collection c = deviceType.getSpecificDeviceTypes();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            DeviceType aDeviceType = (DeviceType)i.next();
            this.transforms.put(aDeviceType, newTransformClone);
            this.fireElementTransformUpdated(aDeviceType);
        }
    }

    public void addInteractionElementListener(InteractionElementListener listener) {
        this.elementEventSource.addInteractionElementListener(listener);
    }

    public void removeInteractionElementListener(InteractionElementListener listener) {
        this.elementEventSource.removeInteractionElementListener(listener);
    }

    protected void fireElementBoundsUpdated(DeviceType deviceType) {
        this.elementEventSource.fireElementBoundsUpdated(this, deviceType);
    }

    protected void fireElementTransformUpdated(DeviceType deviceType) {
        this.elementEventSource.fireElementTransformUpdated(this, deviceType);
    }

    protected void fireElementBorderUpdated(DeviceType deviceType) {
        this.elementEventSource.fireElementBorderUpdated(this, deviceType);
    }

    public Object clone() {
        try {
            AbstractInteractionElement clone = (AbstractInteractionElement)super.clone();
            clone.id = new GUID();
            clone.bounds = new HashMap(this.bounds);
            clone.transforms = new HashMap(this.transforms);
            clone.elementEventSource = new InteractionElementSource();
            clone.cloneSource = new WeakReference<AbstractInteractionElement>(this);
            this.lastClone = new WeakReference<AbstractInteractionElement>(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Object doesn't support clone - yeah right");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassLib.getShortClassName(this));
        sb.append(this.getId().toShortString());
        return sb.toString();
    }

    public abstract String toLongString(int var1, DeviceType var2);
}

