/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import sun.dc.path.FastPathProducer;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathStroker;

public class PFixedWidthStroke
implements Stroke,
Serializable {
    private static PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static GeneralPath TEMP_PATH = new GeneralPath(1);
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private float width;
    private int join;
    private int cap;
    private float miterlimit;
    private float[] dash;
    private float dash_phase;
    public static final int[] RasterizerCaps = new int[]{30, 10, 20};
    public static final int[] RasterizerCorners = new int[]{50, 10, 40};

    public PFixedWidthStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }

    public PFixedWidthStroke(float width) {
        this(width, 2, 0, 10.0f, null, 0.0f);
    }

    public PFixedWidthStroke(float width, int cap, int join) {
        this(width, cap, join, 10.0f, null, 0.0f);
    }

    public PFixedWidthStroke(float width, int cap, int join, float miterlimit) {
        this(width, cap, join, miterlimit, null, 0.0f);
    }

    public PFixedWidthStroke(float width, int cap, int join, float miterlimit, float[] dash, float dash_phase) {
        if (width < 0.0f) {
            throw new IllegalArgumentException("negative width");
        }
        if (cap != 0 && cap != 1 && cap != 2) {
            throw new IllegalArgumentException("illegal end cap value");
        }
        if (join == 0) {
            if (miterlimit < 1.0f) {
                throw new IllegalArgumentException("miter limit < 1");
            }
        } else if (join != 1 && join != 2) {
            throw new IllegalArgumentException("illegal line join value");
        }
        if (dash != null) {
            if (dash_phase < 0.0f) {
                throw new IllegalArgumentException("negative dash phase");
            }
            boolean allzero = true;
            for (int i = 0; i < dash.length; ++i) {
                float d = dash[i];
                if ((double)d > 0.0) {
                    allzero = false;
                    continue;
                }
                if (!((double)d < 0.0)) continue;
                throw new IllegalArgumentException("negative dash length");
            }
            if (allzero) {
                throw new IllegalArgumentException("dash lengths all zero");
            }
        }
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.miterlimit = miterlimit;
        if (dash != null) {
            this.dash = (float[])dash.clone();
        }
        this.dash_phase = dash_phase;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Shape createStrokedShape(Shape s) {
        PathStroker consumer;
        FillAdapter filler = new FillAdapter();
        PathStroker stroker = new PathStroker((PathConsumer)filler);
        float fixedWidth = 1.0f;
        if (PPaintContext.CURRENT_PAINT_CONTEXT != null) {
            fixedWidth = this.width / (float)PPaintContext.CURRENT_PAINT_CONTEXT.getScale();
        }
        Rectangle2D bounds = s.getBounds2D();
        double scale = 1.0;
        scale = bounds.getWidth() > bounds.getHeight() ? (bounds.getWidth() - (double)fixedWidth) / bounds.getWidth() : (bounds.getHeight() - (double)fixedWidth) / bounds.getHeight();
        TEMP_TRANSFORM.setToIdentity();
        TEMP_TRANSFORM.scaleAboutPoint(scale, bounds.getCenterX(), bounds.getCenterY());
        stroker.setPenDiameter(fixedWidth);
        PathIterator pi = s.getPathIterator(TEMP_TRANSFORM);
        stroker.setPenT4(null);
        stroker.setCaps(RasterizerCaps[this.cap]);
        stroker.setCorners(RasterizerCorners[this.join], this.miterlimit);
        if (this.dash != null) {
            PathDasher dasher = new PathDasher((PathConsumer)stroker);
            dasher.setDash(this.dash, this.dash_phase);
            dasher.setDashT4(null);
            consumer = dasher;
        } else {
            consumer = stroker;
        }
        try {
            consumer.beginPath();
            boolean pathClosed = false;
            float mx = 0.0f;
            float my = 0.0f;
            float[] point = new float[6];
            while (!pi.isDone()) {
                int type = pi.currentSegment(point);
                if (pathClosed) {
                    pathClosed = false;
                    if (type != 0) {
                        consumer.beginSubpath(mx, my);
                    }
                }
                switch (type) {
                    case 0: {
                        mx = point[0];
                        my = point[1];
                        consumer.beginSubpath(point[0], point[1]);
                        break;
                    }
                    case 1: {
                        consumer.appendLine(point[0], point[1]);
                        break;
                    }
                    case 2: {
                        consumer.appendQuadratic(point[0], point[1], point[2], point[3]);
                        break;
                    }
                    case 3: {
                        consumer.appendCubic(point[0], point[1], point[2], point[3], point[4], point[5]);
                        break;
                    }
                    case 4: {
                        consumer.closedSubpath();
                        pathClosed = true;
                    }
                }
                pi.next();
            }
            consumer.endPath();
        }
        catch (PathException e) {
            throw new InternalError("Unable to Stroke shape (" + e.getMessage() + ")");
        }
        return filler.getShape();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PFixedWidthStroke)) {
            return false;
        }
        PFixedWidthStroke bs = (PFixedWidthStroke)obj;
        if (this.width != bs.width) {
            return false;
        }
        if (this.join != bs.join) {
            return false;
        }
        if (this.cap != bs.cap) {
            return false;
        }
        if (this.miterlimit != bs.miterlimit) {
            return false;
        }
        if (this.dash != null) {
            if (this.dash_phase != bs.dash_phase) {
                return false;
            }
            if (!Arrays.equals(this.dash, bs.dash)) {
                return false;
            }
        } else if (bs.dash != null) {
            return false;
        }
        return true;
    }

    public float[] getDashArray() {
        if (this.dash == null) {
            return null;
        }
        return (float[])this.dash.clone();
    }

    public float getDashPhase() {
        return this.dash_phase;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getLineWidth() {
        return this.width;
    }

    public float getMiterLimit() {
        return this.miterlimit;
    }

    public int hashCode() {
        int hash = Float.floatToIntBits(this.width);
        hash = hash * 31 + this.join;
        hash = hash * 31 + this.cap;
        hash = hash * 31 + Float.floatToIntBits(this.miterlimit);
        if (this.dash != null) {
            hash = hash * 31 + Float.floatToIntBits(this.dash_phase);
            for (int i = 0; i < this.dash.length; ++i) {
                hash = hash * 31 + Float.floatToIntBits(this.dash[i]);
            }
        }
        return hash;
    }

    static /* synthetic */ GeneralPath access$000() {
        return TEMP_PATH;
    }

    public class FillAdapter
    implements PathConsumer {
        boolean closed;
        GeneralPath path = PFixedWidthStroke.access$000();

        public FillAdapter() {
            this.path.reset();
        }

        public Shape getShape() {
            return this.path;
        }

        public void beginPath() {
        }

        public void beginSubpath(float x0, float y0) {
            if (this.closed) {
                this.path.closePath();
                this.closed = false;
            }
            this.path.moveTo(x0, y0);
        }

        public void appendLine(float x1, float y1) {
            this.path.lineTo(x1, y1);
        }

        public void appendQuadratic(float xm, float ym, float x1, float y1) {
            this.path.quadTo(xm, ym, x1, y1);
        }

        public void appendCubic(float xm, float ym, float xn, float yn, float x1, float y1) {
            this.path.curveTo(xm, ym, xn, yn, x1, y1);
        }

        public void closedSubpath() {
            this.closed = true;
        }

        public void endPath() {
            if (this.closed) {
                this.path.closePath();
                this.closed = false;
            }
        }

        public void useProxy(FastPathProducer proxy) throws PathException {
            proxy.sendTo((PathConsumer)this);
        }

        public long getCPathConsumer() {
            return 0L;
        }

        public void dispose() {
        }
    }
}

