/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PStack;
import edu.umd.cs.piccolox.swt.PSWTKeyEvent;
import edu.umd.cs.piccolox.swt.PSWTMouseEvent;
import edu.umd.cs.piccolox.swt.PSWTRoot;
import edu.umd.cs.piccolox.swt.SWTGraphics2D;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.geom.Rectangle2D;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class PSWTCanvas
extends Composite
implements PComponent {
    public static PSWTCanvas CURRENT_CANVAS = null;
    private Image backBuffer;
    private boolean doubleBuffered = true;
    private PCamera camera;
    private PStack cursorStack;
    private int interacting;
    private int defaultRenderQuality;
    private int animatingRenderQuality;
    private int interactingRenderQuality;
    private PPanEventHandler panEventHandler;
    private PZoomEventHandler zoomEventHandler;
    private boolean paintingImmediately;
    private boolean animatingOnLastPaint;
    private boolean processInputsScheduled;
    private boolean isButton1Pressed;
    private boolean isButton2Pressed;
    private boolean isButton3Pressed;
    private boolean lastModifiers;

    public PSWTCanvas(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x100000);
        CURRENT_CANVAS = this;
        this.cursorStack = new PStack();
        this.setCamera(this.createBasicSceneGraph());
        this.installInputSources();
        this.setDefaultRenderQuality(0);
        this.setAnimatingRenderQuality(1);
        this.setInteractingRenderQuality(1);
        this.panEventHandler = new PPanEventHandler();
        this.zoomEventHandler = new PZoomEventHandler();
        this.addInputEventListener(this.panEventHandler);
        this.addInputEventListener(this.zoomEventHandler);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                PSWTCanvas.this.paintComponent(pe.gc);
            }
        });
        SWTGraphics2D.incrementGCCount();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                PSWTCanvas.this.getRoot().getActivityScheduler().removeAllActivities();
                SWTGraphics2D.decrementGCCount();
            }
        });
    }

    public PPanEventHandler getPanEventHandler() {
        return this.panEventHandler;
    }

    public PZoomEventHandler getZoomEventHandler() {
        return this.zoomEventHandler;
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setCamera(PCamera newCamera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = newCamera;
        if (this.camera != null) {
            this.camera.setComponent(this);
            Rectangle swtRect = this.getBounds();
            this.camera.setBounds(new Rectangle2D.Double(swtRect.x, swtRect.y, swtRect.width, swtRect.height));
        }
    }

    public PRoot getRoot() {
        return this.camera.getRoot();
    }

    public PLayer getLayer() {
        return this.camera.getLayer(0);
    }

    public void addInputEventListener(PInputEventListener listener) {
        this.getCamera().addInputEventListener(listener);
    }

    public void removeInputEventListener(PInputEventListener listener) {
        this.getCamera().removeInputEventListener(listener);
    }

    public PCamera createBasicSceneGraph() {
        PSWTRoot r = new PSWTRoot(this);
        PLayer l = new PLayer();
        PCamera c = new PCamera();
        r.addChild(c);
        r.addChild(l);
        c.addLayer(l);
        return c;
    }

    public boolean getInteracting() {
        return this.interacting > 0;
    }

    public boolean getAnimating() {
        return this.getRoot().getActivityScheduler().getAnimating();
    }

    public void setInteracting(boolean isInteracting) {
        this.interacting = isInteracting ? ++this.interacting : --this.interacting;
        if (!this.getInteracting()) {
            this.repaint();
        }
    }

    public boolean getDoubleBuffered() {
        return this.doubleBuffered;
    }

    public void setDoubleBuffered(boolean dBuffered) {
        this.doubleBuffered = dBuffered;
    }

    public void setDefaultRenderQuality(int requestedQuality) {
        this.defaultRenderQuality = requestedQuality;
        this.repaint();
    }

    public void setAnimatingRenderQuality(int requestedQuality) {
        this.animatingRenderQuality = requestedQuality;
        this.repaint();
    }

    public void setInteractingRenderQuality(int requestedQuality) {
        this.interactingRenderQuality = requestedQuality;
        this.repaint();
    }

    public void pushCursor(Cursor cursor) {
    }

    public void popCursor() {
    }

    protected void installInputSources() {
        this.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent me) {
                PSWTMouseEvent balanceEvent;
                boolean shouldBalanceEvent = false;
                switch (me.button) {
                    case 1: {
                        if (PSWTCanvas.this.isButton1Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PSWTCanvas.this.isButton1Pressed = true;
                        break;
                    }
                    case 2: {
                        if (PSWTCanvas.this.isButton2Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PSWTCanvas.this.isButton2Pressed = true;
                        break;
                    }
                    case 3: {
                        if (PSWTCanvas.this.isButton3Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PSWTCanvas.this.isButton3Pressed = true;
                    }
                }
                if (shouldBalanceEvent) {
                    balanceEvent = new PSWTMouseEvent(me, 502, 1);
                    PSWTCanvas.this.sendInputEventToInputManager(balanceEvent, 502);
                }
                balanceEvent = new PSWTMouseEvent(me, 501, 1);
                PSWTCanvas.this.sendInputEventToInputManager(balanceEvent, 501);
            }

            public void mouseUp(MouseEvent me) {
                PSWTMouseEvent balanceEvent;
                boolean shouldBalanceEvent = false;
                switch (me.button) {
                    case 1: {
                        if (!PSWTCanvas.this.isButton1Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PSWTCanvas.this.isButton1Pressed = false;
                        break;
                    }
                    case 2: {
                        if (!PSWTCanvas.this.isButton2Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PSWTCanvas.this.isButton2Pressed = false;
                        break;
                    }
                    case 3: {
                        if (!PSWTCanvas.this.isButton3Pressed) {
                            shouldBalanceEvent = true;
                        }
                        PSWTCanvas.this.isButton3Pressed = false;
                    }
                }
                if (shouldBalanceEvent) {
                    balanceEvent = new PSWTMouseEvent(me, 501, 1);
                    PSWTCanvas.this.sendInputEventToInputManager(balanceEvent, 501);
                }
                balanceEvent = new PSWTMouseEvent(me, 502, 1);
                PSWTCanvas.this.sendInputEventToInputManager(balanceEvent, 502);
            }

            public void mouseDoubleClick(MouseEvent me) {
                PSWTMouseEvent inputEvent = new PSWTMouseEvent(me, 500, 2);
                PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 500);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent me) {
                if (PSWTCanvas.this.isButton1Pressed || PSWTCanvas.this.isButton2Pressed || PSWTCanvas.this.isButton3Pressed) {
                    PSWTMouseEvent inputEvent = new PSWTMouseEvent(me, 506, 1);
                    PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 506);
                } else {
                    PSWTMouseEvent inputEvent = new PSWTMouseEvent(me, 503, 1);
                    PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 503);
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
                PSWTKeyEvent inputEvent = new PSWTKeyEvent(ke, 401);
                PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 401);
            }

            public void keyReleased(KeyEvent ke) {
                PSWTKeyEvent inputEvent = new PSWTKeyEvent(ke, 402);
                PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 402);
            }
        });
    }

    protected void sendInputEventToInputManager(InputEvent e, int type) {
        this.getRoot().getDefaultInputManager().processEventFromCamera(e, type, this.getCamera());
    }

    public void setBounds(int x, int y, int w, int h) {
        this.camera.setBounds(this.camera.getX(), this.camera.getY(), w, h);
        if (this.backBuffer == null || this.backBuffer.getBounds().width < w || this.backBuffer.getBounds().height < h) {
            this.backBuffer = new Image((Device)this.getDisplay(), w, h);
        }
        super.setBounds(x, y, w, h);
    }

    public void repaint() {
        super.redraw();
    }

    public void repaint(PBounds bounds) {
        bounds.expandNearestIntegerDimensions();
        bounds.inset(-1.0, -1.0);
        this.redraw((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, true);
    }

    public void paintComponent(GC gc) {
        PDebug.startProcessingOutput();
        GC imageGC = null;
        SWTGraphics2D g2 = null;
        if (this.doubleBuffered) {
            imageGC = new GC((Drawable)this.backBuffer);
            g2 = new SWTGraphics2D(imageGC, (Device)this.getDisplay());
        } else {
            g2 = new SWTGraphics2D(gc, (Device)this.getDisplay());
        }
        ((Graphics)g2).setColor(Color.white);
        ((Graphics2D)g2).setBackground(Color.white);
        Rectangle rect = this.getBounds();
        ((Graphics)g2).fillRect(0, 0, rect.width, rect.height);
        PPaintContext paintContext = new PPaintContext(g2);
        if (this.getInteracting() || this.getAnimating()) {
            if (this.interactingRenderQuality > this.animatingRenderQuality) {
                paintContext.setRenderQuality(this.interactingRenderQuality);
            } else {
                paintContext.setRenderQuality(this.animatingRenderQuality);
            }
        } else {
            paintContext.setRenderQuality(this.defaultRenderQuality);
        }
        this.camera.fullPaint(paintContext);
        if (!this.getAnimating() && this.animatingOnLastPaint) {
            this.repaint();
        }
        this.animatingOnLastPaint = this.getAnimating();
        PDebug.endProcessingOutput(g2);
        if (this.doubleBuffered) {
            gc.drawImage(this.backBuffer, 0, 0);
            imageGC.dispose();
        }
    }

    public void paintImmediately() {
        if (this.paintingImmediately) {
            return;
        }
        this.paintingImmediately = true;
        this.redraw();
        this.update();
        this.paintingImmediately = false;
    }
}

