/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleContext;

public class PStyledText
extends PNode {
    protected static FontRenderContext SWING_FRC = new FontRenderContext(null, true, false);
    protected static Component metricSrc = new Component(){};
    protected Document document;
    protected transient ArrayList stringContents;
    protected transient LineInfo[] lines;
    protected boolean editing;
    protected Insets insets = new Insets(0, 0, 0, 0);
    protected boolean constrainHeightToTextHeight = true;
    protected boolean constrainWidthToTextWidth = true;

    public void setConstrainWidthToTextWidth(boolean constrainWidthToTextWidth) {
        this.constrainWidthToTextWidth = constrainWidthToTextWidth;
        this.recomputeLayout();
    }

    public void setConstrainHeightToTextHeight(boolean constrainHeightToTextHeight) {
        this.constrainHeightToTextHeight = constrainHeightToTextHeight;
        this.recomputeLayout();
    }

    public boolean getConstrainWidthToTextWidth() {
        return this.constrainWidthToTextWidth;
    }

    public boolean getConstrainHeightToTextHeight() {
        return this.constrainHeightToTextHeight;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
        this.syncWithDocument();
    }

    public void syncWithDocument() {
        ArrayList<RunInfo> pEnds = null;
        int pos = 0;
        try {
            this.stringContents = new ArrayList();
            pEnds = new ArrayList<RunInfo>();
            String s = this.document.getText(0, this.document.getLength());
            StringTokenizer tokenizer = new StringTokenizer(s, "\n", true);
            boolean lastNewLine = true;
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    if (lastNewLine) {
                        this.stringContents.add(new AttributedString(" "));
                        pEnds.add(new RunInfo(pos, pos + 1));
                        ++pos;
                        lastNewLine = true;
                    } else {
                        ++pos;
                        lastNewLine = true;
                    }
                } else if (token.equals("")) {
                    this.stringContents.add(new AttributedString(" "));
                    pEnds.add(new RunInfo(pos, pos));
                    lastNewLine = false;
                } else {
                    this.stringContents.add(new AttributedString(token));
                    pEnds.add(new RunInfo(pos, pos + token.length()));
                    pos += token.length();
                    lastNewLine = false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StyleContext style = StyleContext.getDefaultStyleContext();
        RunInfo pEnd = null;
        for (int i = 0; i < this.stringContents.size(); ++i) {
            Color foreground;
            Font font;
            AttributeSet attributes;
            pEnd = (RunInfo)pEnds.get(i);
            pos = pEnd.runStart;
            Element curElement = null;
            Element rootElement = this.document.getRootElements()[0];
            if (pEnd.runStart != pEnd.runLimit) {
                while (pos < pEnd.runLimit) {
                    curElement = rootElement;
                    while (!curElement.isLeaf()) {
                        curElement = curElement.getElement(curElement.getElementIndex(pos));
                    }
                    attributes = curElement.getAttributes();
                    font = style.getFont(attributes);
                    foreground = style.getForeground(attributes);
                    ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.FONT, font, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                    ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.FOREGROUND, foreground, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
                    pos = curElement.getEndOffset();
                }
                continue;
            }
            curElement = rootElement;
            while (!curElement.isLeaf()) {
                curElement = curElement.getElement(curElement.getElementIndex(pos));
            }
            attributes = curElement.getAttributes();
            font = style.getFont(attributes);
            foreground = style.getForeground(attributes);
            ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.FONT, font, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
            ((AttributedString)this.stringContents.get(i)).addAttribute(TextAttribute.FOREGROUND, foreground, Math.max(0, curElement.getStartOffset() - pEnd.runStart), Math.min(pEnd.runLimit - pEnd.runStart, curElement.getEndOffset() - pEnd.runStart));
        }
        this.recomputeLayout();
    }

    public void recomputeLayout() {
        if (this.stringContents == null) {
            return;
        }
        ArrayList<LineInfo> linesList = new ArrayList<LineInfo>();
        ArrayList<MetricsRunInfo> runs = new ArrayList<MetricsRunInfo>();
        double textWidth = 0.0;
        double textHeight = 0.0;
        for (int i = 0; i < this.stringContents.size(); ++i) {
            runs.clear();
            AttributedCharacterIterator itr = ((AttributedString)this.stringContents.get(i)).getIterator();
            while (itr.current() != '\uffff') {
                int runLimit = itr.getRunLimit(TextAttribute.FONT);
                Font f = (Font)itr.getAttribute(TextAttribute.FONT);
                MetricsRunInfo info = new MetricsRunInfo();
                info.runStart = itr.getIndex();
                info.runLimit = runLimit;
                info.metrics = metricSrc.getFontMetrics(f);
                runs.add(info);
                itr.setIndex(runLimit);
            }
            itr.first();
            ArrayList<Integer> breakList = null;
            if (!this.constrainWidthToTextWidth) {
                LineBreakMeasurer measurer = new LineBreakMeasurer(itr, SWING_FRC);
                breakList = new ArrayList<Integer>();
                while (measurer.getPosition() < itr.getEndIndex()) {
                    if (this.constrainWidthToTextWidth) {
                        measurer.nextLayout(Float.MAX_VALUE);
                    } else {
                        measurer.nextLayout((float)Math.ceil(this.getWidth() - (double)this.insets.left - (double)this.insets.right));
                    }
                    breakList.add(new Integer(measurer.getPosition()));
                }
            }
            LineBreakMeasurer measurer = new LineBreakMeasurer(itr, PPaintContext.RENDER_QUALITY_HIGH_FRC);
            while (measurer.getPosition() < itr.getEndIndex()) {
                TextLayout aTextLayout = null;
                if (this.constrainWidthToTextWidth) {
                    aTextLayout = measurer.nextLayout(Float.MAX_VALUE);
                } else {
                    aTextLayout = measurer.nextLayout(Float.MAX_VALUE, (Integer)breakList.get(0), false);
                    breakList.remove(0);
                }
                MetricsRunInfo info = (MetricsRunInfo)runs.get(0);
                double maxAscent = info.metrics.getMaxAscent();
                double maxDescent = info.metrics.getMaxDescent();
                double leading = info.metrics.getLeading();
                while (info.runStart < itr.getIndex()) {
                    info = (MetricsRunInfo)runs.get(0);
                    maxAscent = Math.max(maxAscent, (double)info.metrics.getMaxAscent());
                    maxDescent = Math.max(maxDescent, (double)info.metrics.getMaxDescent());
                    leading = Math.max(leading, (double)info.metrics.getLeading());
                    if (info.runLimit > itr.getIndex() || runs.size() <= 1) break;
                    runs.remove(0);
                    info = (MetricsRunInfo)runs.get(0);
                }
                LineInfo lineInfo = new LineInfo();
                lineInfo.foreground = (Color)itr.getAttribute(TextAttribute.FOREGROUND);
                lineInfo.layout = aTextLayout;
                lineInfo.maxAscent = maxAscent;
                lineInfo.maxDescent = maxDescent;
                lineInfo.leading = leading;
                linesList.add(lineInfo);
                textHeight += maxAscent;
                textHeight += maxDescent + leading;
                textWidth = Math.max(textWidth, (double)aTextLayout.getAdvance());
            }
        }
        this.lines = linesList.toArray(new LineInfo[0]);
        if (this.constrainWidthToTextWidth || this.constrainHeightToTextHeight) {
            double newWidth = this.getWidth();
            double newHeight = this.getHeight();
            if (this.constrainWidthToTextWidth) {
                newWidth = textWidth + (double)this.insets.left + (double)this.insets.right;
            }
            if (this.constrainHeightToTextHeight) {
                newHeight = Math.max(textHeight, this.getInitialFontHeight()) + (double)this.insets.top + (double)this.insets.bottom;
            }
            super.setBounds(this.getX(), this.getY(), newWidth, newHeight);
        }
    }

    public double getInitialFontHeight() {
        Element rootElement;
        Element curElement = rootElement = this.document.getDefaultRootElement();
        while (!curElement.isLeaf()) {
            curElement = curElement.getElement(curElement.getElementIndex(0));
        }
        StyleContext context = StyleContext.getDefaultStyleContext();
        Font font = context.getFont(curElement.getAttributes());
        FontMetrics curFM = metricSrc.getFontMetrics(font);
        return curFM.getMaxAscent() + curFM.getMaxDescent() + curFM.getLeading();
    }

    protected void paint(PPaintContext paintContext) {
        float x = (float)(this.getX() + (double)this.insets.left);
        float y = (float)(this.getY() + (double)this.insets.top);
        float bottomY = (float)(this.getY() + this.getHeight() - (double)this.insets.bottom);
        if (this.lines == null) {
            return;
        }
        Graphics2D g2 = paintContext.getGraphics();
        if (this.getPaint() != null) {
            g2.setPaint(this.getPaint());
            g2.fill(this.getBounds());
        }
        for (int i = 0; i < this.lines.length; ++i) {
            if (bottomY < (y = (float)((double)y + this.lines[i].maxAscent))) {
                return;
            }
            g2.setPaint(this.lines[i].foreground);
            this.lines[i].layout.draw(g2, x, y);
            y = (float)((double)y + (this.lines[i].maxDescent + this.lines[i].leading));
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        if (!this.editing) {
            super.fullPaint(paintContext);
        }
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setInsets(Insets insets) {
        if (insets != null) {
            this.insets.left = insets.left;
            this.insets.right = insets.right;
            this.insets.top = insets.top;
            this.insets.bottom = insets.bottom;
            this.recomputeLayout();
        }
    }

    public Insets getInsets() {
        return (Insets)this.insets.clone();
    }

    public boolean setBounds(double x, double y, double w, double h) {
        if (this.document == null || !super.setBounds(x, y, w, h)) {
            return false;
        }
        this.recomputeLayout();
        return true;
    }

    protected static class LineInfo {
        public TextLayout layout;
        public Color foreground;
        public double maxAscent;
        public double maxDescent;
        public double leading;

        protected LineInfo() {
        }
    }

    protected static class MetricsRunInfo
    extends RunInfo {
        public FontMetrics metrics;

        protected MetricsRunInfo() {
        }
    }

    protected static class RunInfo {
        public int runStart;
        public int runLimit;

        public RunInfo() {
        }

        public RunInfo(int runStart, int runLimit) {
            this.runStart = runStart;
            this.runLimit = runLimit;
        }
    }
}

