/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.PFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class P3DRect
extends PNode {
    private Color topLeftOuterColor;
    private Color topLeftInnerColor;
    private Color bottomRightInnerColor;
    private Color bottomRightOuterColor;
    private GeneralPath path;
    private Stroke stroke = new BasicStroke(0.0f);
    private boolean raised = true;

    public P3DRect() {
        this.path = new GeneralPath();
    }

    public P3DRect(Rectangle2D bounds) {
        this(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public P3DRect(double x, double y, double width, double height) {
        this();
        this.setBounds(x, y, width, height);
    }

    public void setRaised(boolean raised) {
        this.raised = raised;
        this.setPaint(this.getPaint());
    }

    public boolean getRaised() {
        return this.raised;
    }

    protected void paint(PPaintContext paintContext) {
        Graphics2D g2 = paintContext.getGraphics();
        double x = this.getX();
        double y = this.getY();
        double width = this.getWidth();
        double height = this.getHeight();
        double magX = g2.getTransform().getScaleX();
        double magY = g2.getTransform().getScaleY();
        double dx = (float)(1.0 / magX);
        double dy = (float)(1.0 / magY);
        PBounds bounds = this.getBounds();
        g2.setPaint(this.getPaint());
        g2.fill(bounds);
        g2.setStroke(this.stroke);
        this.path.reset();
        this.path.moveTo((float)(x + width), (float)y);
        this.path.lineTo((float)x, (float)y);
        this.path.lineTo((float)x, (float)(y + height));
        g2.setPaint(this.topLeftOuterColor);
        g2.draw(this.path);
        this.path.reset();
        this.path.moveTo((float)(x + width), (float)(y + dy));
        this.path.lineTo((float)(x + dx), (float)(y + dy));
        this.path.lineTo((float)(x + dx), (float)(y + height));
        g2.setPaint(this.topLeftInnerColor);
        g2.draw(this.path);
        this.path.reset();
        this.path.moveTo((float)(x + width), (float)y);
        this.path.lineTo((float)(x + width), (float)(y + height));
        this.path.lineTo((float)x, (float)(y + height));
        g2.setPaint(this.bottomRightOuterColor);
        g2.draw(this.path);
        this.path.reset();
        this.path.moveTo((float)(x + width - dx), (float)(y + dy));
        this.path.lineTo((float)(x + width - dx), (float)(y + height - dy));
        this.path.lineTo((float)x, (float)(y + height - dy));
        g2.setPaint(this.bottomRightInnerColor);
        g2.draw(this.path);
    }

    public void setPaint(Paint newPaint) {
        super.setPaint(newPaint);
        if (newPaint instanceof Color) {
            Color color = (Color)newPaint;
            if (this.raised) {
                this.topLeftOuterColor = color.brighter();
                this.topLeftInnerColor = this.topLeftOuterColor.brighter();
                this.bottomRightInnerColor = color.darker();
                this.bottomRightOuterColor = this.bottomRightInnerColor.darker();
            } else {
                this.topLeftOuterColor = color.darker();
                this.topLeftInnerColor = this.topLeftOuterColor.darker();
                this.bottomRightInnerColor = color.brighter();
                this.bottomRightOuterColor = this.bottomRightInnerColor.brighter();
            }
        } else {
            this.topLeftOuterColor = null;
            this.topLeftInnerColor = null;
            this.bottomRightInnerColor = null;
            this.bottomRightOuterColor = null;
        }
    }

    public static void main(String[] args) {
        new PFrame(){

            public void initialize() {
                this.getCanvas().setDefaultRenderQuality(1);
                P3DRect rect1 = new P3DRect(50.0, 50.0, 100.0, 100.0);
                rect1.setPaint(new Color(239, 235, 222));
                P3DRect rect2 = new P3DRect(50.0, 50.0, 100.0, 100.0);
                rect2.setPaint(new Color(239, 235, 222));
                rect2.translate(110.0, 0.0);
                rect2.setRaised(false);
                this.getCanvas().getLayer().addChild(rect1);
                this.getCanvas().getLayer().addChild(rect2);
            }
        };
    }
}

