/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox;

import edu.umd.cs.piccolo.PCanvas;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class PFrame
extends JFrame {
    private PCanvas canvas;
    private GraphicsDevice graphicsDevice;
    private DisplayMode originalDisplayMode;
    private EventListener escapeFullScreenModeListener;

    public PFrame() {
        this(false, null);
    }

    public PFrame(boolean fullScreenMode, PCanvas aCanvas) {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice(), fullScreenMode, aCanvas);
    }

    public PFrame(GraphicsDevice aDevice, boolean fullScreenMode, PCanvas aCanvas) {
        super(aDevice.getDefaultConfiguration());
        this.graphicsDevice = aDevice;
        try {
            this.originalDisplayMode = this.graphicsDevice.getDisplayMode();
        }
        catch (InternalError e) {
            e.printStackTrace();
        }
        this.setBounds(this.getDefaultFrameBounds());
        this.setBackground(null);
        try {
            this.setDefaultCloseOperation(3);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.canvas = aCanvas == null ? new PCanvas() : aCanvas;
        this.getContentPane().add(this.canvas);
        this.validate();
        this.setFullScreenMode(fullScreenMode);
        this.canvas.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PFrame.this.initialize();
                PFrame.this.repaint();
            }
        });
    }

    public PCanvas getCanvas() {
        return this.canvas;
    }

    public Rectangle getDefaultFrameBounds() {
        return new Rectangle(100, 100, 400, 400);
    }

    public void setFullScreenMode(boolean fullScreenMode) {
        if (fullScreenMode) {
            this.addEscapeFullScreenModeListener();
            if (this.isDisplayable()) {
                this.dispose();
            }
            this.setUndecorated(true);
            this.setResizable(false);
            this.graphicsDevice.setFullScreenWindow(this);
            if (this.graphicsDevice.isDisplayChangeSupported()) {
                this.chooseBestDisplayMode(this.graphicsDevice);
            }
            this.validate();
        } else {
            this.removeEscapeFullScreenModeListener();
            if (this.isDisplayable()) {
                this.dispose();
            }
            this.setUndecorated(false);
            this.setResizable(true);
            this.graphicsDevice.setFullScreenWindow(null);
            this.validate();
            this.setVisible(true);
        }
    }

    protected void chooseBestDisplayMode(GraphicsDevice device) {
        DisplayMode best = this.getBestDisplayMode(device);
        if (best != null) {
            device.setDisplayMode(best);
        }
    }

    protected DisplayMode getBestDisplayMode(GraphicsDevice device) {
        Iterator itr = this.getPreferredDisplayModes(device).iterator();
        while (itr.hasNext()) {
            DisplayMode each = (DisplayMode)itr.next();
            DisplayMode[] modes = device.getDisplayModes();
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i].getWidth() != each.getWidth() || modes[i].getHeight() != each.getHeight() || modes[i].getBitDepth() != each.getBitDepth()) continue;
                return each;
            }
        }
        return null;
    }

    protected Collection getPreferredDisplayModes(GraphicsDevice device) {
        ArrayList<DisplayMode> result = new ArrayList<DisplayMode>();
        result.add(device.getDisplayMode());
        return result;
    }

    public void addEscapeFullScreenModeListener() {
        this.removeEscapeFullScreenModeListener();
        this.escapeFullScreenModeListener = new KeyAdapter(){

            public void keyPressed(KeyEvent aEvent) {
                if (aEvent.getKeyCode() == 27) {
                    PFrame.this.setFullScreenMode(false);
                }
            }
        };
        this.canvas.addKeyListener((KeyListener)this.escapeFullScreenModeListener);
    }

    public void removeEscapeFullScreenModeListener() {
        if (this.escapeFullScreenModeListener != null) {
            this.canvas.removeKeyListener((KeyListener)this.escapeFullScreenModeListener);
            this.escapeFullScreenModeListener = null;
        }
    }

    public void initialize() {
    }

    public static void main(String[] argv) {
        new PFrame();
    }
}

